/*
 * Decompiled with CFR 0.152.
 */
package com.yeliheng.eventbus.spring.context;

import com.yeliheng.eventbus.EventBus;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class EventBusContext
implements ApplicationListener<ApplicationContextEvent> {
    public static final Logger logger = LoggerFactory.getLogger(EventBusContext.class);
    private ApplicationContext applicationContext;
    private static EventBusContext instance;

    public static EventBusContext getEventContext() {
        return instance;
    }

    public static ApplicationContext getApplicationContext() {
        return EventBusContext.instance.applicationContext;
    }

    private synchronized void shutdownSafely() {
        try {
            Field executorField = EventBus.class.getDeclaredField("executor");
            executorField.setAccessible(true);
            ExecutorService executorService = (ExecutorService)executorField.get(null);
            executorService.shutdown();
        }
        catch (Exception e) {
            logger.error(String.format("Failed to shutdown, Unexpected exception: %s", e.getMessage()));
            return;
        }
        logger.info("EventBus successfully shutdown.");
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            instance = this;
            this.applicationContext = event.getApplicationContext();
            logger.info("EventBus initialized.");
        } else if (event instanceof ContextClosedEvent) {
            this.shutdownSafely();
        }
    }
}

