/*
 * Decompiled with CFR 0.152.
 */
package com.yepher.jsondoc;

import com.yepher.jsondoc.Documentor;
import com.yepher.jsondoc.DocumentorDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;

public abstract class ClassListDriverBase
implements DocumentorDriver {
    private PrintStream console;
    public boolean generateFooter = true;
    private BufferedReader in;
    private PrintStream out;

    @Override
    public abstract void addPduToDocument(Class<?> var1);

    protected abstract Set<Class<?>> getPdusToExclude();

    protected abstract List<Class<?>> getPdusToDocument();

    protected abstract String getTitle();

    protected abstract void setOutputPath(String var1);

    protected abstract String getOutputPath();

    @Override
    public void emit(String text) {
        this.out.print(this.sanitize(text));
    }

    @Override
    public void emitLine() {
        this.out.println();
    }

    @Override
    public void emitLine(String text) {
        this.out.println(this.sanitize(text));
    }

    @Override
    public void printToConsole(String line) {
        this.console.println(line);
    }

    private String getHeader() {
        return null;
    }

    public String getFooter() {
        return this.getTitle() + " markdown generated by [json-doc](https://github.com/yepher/json-doc)";
    }

    protected ClassListDriverBase() {
    }

    protected void run(String[] args) throws Exception {
        this.console = System.out;
        InputStreamReader inReader = new InputStreamReader(System.in, "utf-8");
        this.in = new BufferedReader(inReader);
        if (args != null && args.length > 0) {
            this.setOutputPath(args[0]);
        }
        this.console.println("generating \"" + this.getTitle() + "\" markdown documentation to: " + this.getOutputPath());
        File outputFile = new File(this.getOutputPath());
        if (outputFile.exists()) {
            String response = "";
            while (response != null && !response.equalsIgnoreCase("y")) {
                this.console.println(this.getOutputPath() + " exists. overwrite (y/n)? ");
                response = this.in.readLine();
                if (response == null || !response.equalsIgnoreCase("n")) continue;
                this.console.println("protocol documentation will NOT be generated!!!");
                return;
            }
            this.console.println(this.getOutputPath() + " will be overwritten!");
        } else {
            outputFile.createNewFile();
        }
        FileOutputStream outStream = new FileOutputStream(outputFile);
        this.out = new PrintStream(outStream);
        String header = this.getHeader();
        if (header != null) {
            this.emitLine();
            this.emitLine(header);
            this.emitLine();
        }
        String text = "# " + this.getTitle();
        this.emitLine(text);
        this.emitLine();
        Documentor documentor = new Documentor();
        documentor.setDriver(this);
        List<Class<?>> pdusToDocument = this.getPdusToDocument();
        for (int i = 0; i < pdusToDocument.size(); ++i) {
            Class<?> pdu = pdusToDocument.get(i);
            if (this.getPdusToExclude().contains(pdu)) continue;
            documentor.documentPDU(pdu);
        }
        String footer = this.getFooter();
        if (footer != null) {
            this.emitLine();
            this.emitLine(footer);
            this.emitLine();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    private String sanitize(String string) {
        String result = string.replaceAll("\\&", "&amp;");
        result = result.replaceAll("\\<", "&lt;");
        return result;
    }
}

