/*
 * Decompiled with CFR 0.152.
 */
package com.yepher.jsondoc;

import com.google.gson.annotations.SerializedName;
import com.yepher.jsondoc.DocumentorDriver;
import com.yepher.jsondoc.annotations.Description;
import com.yepher.jsondoc.annotations.RequestPDU;
import com.yepher.jsondoc.annotations.ResponsePDU;
import com.yepher.jsondoc.helpers.GsonHelper;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Documentor {
    private DocumentorDriver driver;
    private GsonHelper gson = GsonHelper.getInstance();
    private Map<Class<? extends Object>, List<? extends Object>> samples;
    private Map<Class<? extends Object>, TypeParser<?>> specialTypes;

    public Documentor() throws Exception {
        this.gson.setPrettyPrinting(true);
        this.samples = new HashMap<Class<? extends Object>, List<? extends Object>>();
        this.specialTypes = new HashMap();
        TypeParser<Boolean> typeParser = new BooleanParser();
        this.specialTypes.put(Boolean.TYPE, typeParser);
        this.specialTypes.put(Boolean.class, typeParser);
        typeParser = new CharacterParser();
        this.specialTypes.put(Character.TYPE, typeParser);
        this.specialTypes.put(Character.class, typeParser);
        typeParser = new ByteParser();
        this.specialTypes.put(Byte.TYPE, typeParser);
        this.specialTypes.put(Byte.class, typeParser);
        typeParser = new ShortParser();
        this.specialTypes.put(Short.TYPE, typeParser);
        this.specialTypes.put(Short.class, typeParser);
        typeParser = new IntegerParser();
        this.specialTypes.put(Integer.TYPE, typeParser);
        this.specialTypes.put(Integer.class, typeParser);
        typeParser = new LongParser();
        this.specialTypes.put(Long.TYPE, typeParser);
        this.specialTypes.put(Long.class, typeParser);
        typeParser = new FloatParser();
        this.specialTypes.put(Float.TYPE, typeParser);
        this.specialTypes.put(Float.class, typeParser);
        typeParser = new DoubleParser();
        this.specialTypes.put(Double.TYPE, typeParser);
        this.specialTypes.put(Double.class, typeParser);
        typeParser = new VoidParser();
        this.specialTypes.put(Void.TYPE, typeParser);
        this.specialTypes.put(Void.class, typeParser);
        typeParser = new StringParser();
        this.specialTypes.put(String.class, typeParser);
    }

    public void setDriver(DocumentorDriver driver) {
        this.driver = driver;
    }

    public void documentPDU(Class<?> pdu) {
        Class<?> listType;
        String typeName;
        Class<?> fieldType;
        ResponsePDU responseAnnotation;
        RequestPDU requestAnnotation;
        String description;
        String pduName = pdu.getSimpleName();
        this.driver.printToConsole("documenting: " + pduName);
        this.emitLine("## " + pduName);
        this.emitLine();
        Description descriptionAnnotation = pdu.getAnnotation(Description.class);
        if (descriptionAnnotation != null && (description = descriptionAnnotation.value()) != null) {
            this.emitLine(description);
            this.emitLine();
        }
        if ((requestAnnotation = pdu.getAnnotation(RequestPDU.class)) != null) {
            int responsesLength;
            Class[] responses;
            String[] postParts;
            String[] requestParameters;
            int i;
            String[] pathParameters;
            int pathsLength;
            String[] paths;
            RequestPDU.Method[] methods = requestAnnotation.method();
            if (methods != null && methods.length > 0) {
                if (methods.length == 1) {
                    this.emitLine("HTTP method: " + methods[0].name());
                } else {
                    this.emit("HTTP methods: " + methods[0].name());
                    for (int i2 = 1; i2 < methods.length; ++i2) {
                        this.emit(", " + methods[i2].name());
                    }
                    this.emitLine();
                }
                this.emitLine();
            }
            if ((paths = requestAnnotation.path()) != null && (pathsLength = paths.length) > 0) {
                if (pathsLength == 1) {
                    this.emitLine("Path: " + paths[0]);
                } else {
                    this.emit("Paths: " + paths[0]);
                    for (int i3 = 0; i3 < pathsLength; ++i3) {
                        this.emit(", " + paths[i3]);
                    }
                    this.emitLine();
                }
                this.emitLine();
            }
            if ((pathParameters = requestAnnotation.pathParameters()) != null) {
                int pathParametersLength = pathParameters.length;
                if (pathParametersLength % 2 != 0) {
                    this.driver.printToConsole("pathParameters length is odd, will reduce by 1, for class: " + pduName);
                    --pathParametersLength;
                }
                if (pathParametersLength > 0) {
                    this.emitLine("Path Parameters:");
                    this.emitLine();
                    this.emitLine("Parameter|Description");
                    this.emitLine(":--------|:----------");
                    for (i = 0; i < pathParameters.length; i += 2) {
                        this.emitLine(pathParameters[i] + "|" + pathParameters[i + 1]);
                    }
                    this.emitLine();
                }
            }
            if ((requestParameters = requestAnnotation.requestParameters()) != null) {
                int requestParametersLength = requestParameters.length;
                if (requestParametersLength % 2 != 0) {
                    this.driver.printToConsole("requestParameters length is odd, will reduce by 1, for class: " + pduName);
                    --requestParametersLength;
                }
                if (requestParametersLength > 0) {
                    this.emitLine("Request Parameters:");
                    this.emitLine();
                    this.emitLine("Parameter|Description");
                    this.emitLine(":--------|:----------");
                    for (i = 0; i < requestParameters.length; i += 2) {
                        this.emitLine(requestParameters[i] + "|" + requestParameters[i + 1]);
                    }
                    this.emitLine();
                }
            }
            if ((postParts = requestAnnotation.multipartPostParts()) != null) {
                int postPartsLength = postParts.length;
                if (postPartsLength % 2 != 0) {
                    this.driver.printToConsole("multipartPostParts length is odd, will reduce by 1, for class: " + pduName);
                    --postPartsLength;
                }
                if (postPartsLength > 0) {
                    this.emitLine("Multi-part POST parts:");
                    this.emitLine();
                    this.emitLine("Part Name|Description");
                    this.emitLine(":---|:----------");
                    for (i = 0; i < postParts.length; i += 2) {
                        this.emitLine(postParts[i] + "|" + postParts[i + 1]);
                    }
                    this.emitLine();
                }
            }
            if ((responses = requestAnnotation.response()) != null && (responsesLength = responses.length) > 0) {
                Class response = responses[0];
                this.addToList(response);
                if (responsesLength == 1) {
                    this.emitLine("Response: " + response.getSimpleName());
                } else {
                    this.emit("Responses: " + response.getSimpleName());
                    for (int i4 = 1; i4 < responsesLength; ++i4) {
                        response = responses[i4];
                        this.addToList(response);
                        this.emit(", " + response.getSimpleName());
                    }
                    this.emitLine();
                }
                this.emitLine();
            }
        }
        if ((responseAnnotation = pdu.getAnnotation(ResponsePDU.class)) != null) {
            Class[] requests = responseAnnotation.request();
            int requestsLength = requests.length;
            if (requests != null && requestsLength > 0) {
                Class request = requests[0];
                this.addToList(request);
                if (requestsLength == 1) {
                    this.emitLine("Request: " + request.getSimpleName());
                } else {
                    this.emit("Requests: " + request.getSimpleName());
                    for (int i = 1; i < requestsLength; ++i) {
                        request = requests[i];
                        this.addToList(request);
                        this.emit(", " + request.getSimpleName());
                    }
                    this.emitLine();
                }
                this.emitLine();
            }
        }
        List<Field> fields = this.getAllFields(pdu);
        boolean headerEmitted = false;
        if (fields.size() > 0) {
            for (Field field : fields) {
                Description descriptionAnnotation2;
                if (this.fieldIsStatic(field)) continue;
                if (!headerEmitted) {
                    this.emitLine("Fields:");
                    this.emitLine();
                    this.emitLine("Type|Name|Serialized Name|Sample|Description");
                    this.emitLine(":---|:---|:-------|:-----|:----------");
                    headerEmitted = true;
                }
                String fieldName = field.getName();
                fieldType = field.getType();
                typeName = fieldType.getSimpleName();
                if (!this.isSpecialType(fieldType)) {
                    listType = this.getListType(field);
                    if (listType == null) {
                        this.addToList(fieldType);
                    } else {
                        typeName = typeName + "<" + listType.getSimpleName() + ">";
                        this.addToList(listType);
                    }
                }
                String serializedName = fieldName;
                String sample = "";
                String description2 = "";
                SerializedName serializedAnnotation = field.getAnnotation(SerializedName.class);
                if (serializedAnnotation != null) {
                    serializedName = serializedAnnotation.value();
                }
                if ((descriptionAnnotation2 = field.getAnnotation(Description.class)) != null) {
                    String[] samples = descriptionAnnotation2.sample();
                    if (samples != null && samples.length > 0) {
                        sample = samples[0];
                    }
                    description2 = descriptionAnnotation2.value();
                }
                this.emitLine(typeName + "|" + fieldName + "|" + serializedName + "|" + sample + "|" + description2);
            }
            this.emitLine();
        }
        headerEmitted = false;
        if (fields.size() > 0) {
            for (Field field : fields) {
                Object value;
                if (!this.fieldIsStatic(field)) continue;
                if (!headerEmitted) {
                    this.emitLine("Constants:");
                    this.emitLine();
                    this.emitLine("Type|Name|Value|Description");
                    this.emitLine(":---|:---|:----|:----------");
                    headerEmitted = true;
                }
                String fieldName = field.getName();
                fieldType = field.getType();
                typeName = fieldType.getSimpleName();
                if (!this.isSpecialType(fieldType)) {
                    listType = this.getListType(field);
                    if (listType == null) {
                        this.addToList(fieldType);
                    } else {
                        typeName = typeName + "<" + listType.getSimpleName() + ">";
                        this.addToList(listType);
                    }
                }
                String description3 = "";
                Description descriptionAnnotation3 = field.getAnnotation(Description.class);
                if (descriptionAnnotation3 != null) {
                    description3 = descriptionAnnotation3.value();
                }
                field.setAccessible(true);
                try {
                    value = field.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    this.driver.printToConsole("exception accessing value of static field " + fieldName + ": " + e.getMessage());
                    continue;
                }
                if (value == null) {
                    value = "[null]";
                }
                this.emitLine(typeName + "|" + fieldName + "|" + value.toString() + "|" + description3);
            }
            this.emitLine();
        }
        if (!(requestAnnotation == null && responseAnnotation == null || requestAnnotation != null && requestAnnotation.noSample())) {
            Object sample = this.getSample(pdu);
            String json = this.gson.toJson(sample);
            this.emitLine("Sample:");
            this.emitLine();
            this.emitLine("```");
            this.emitLine(json);
            this.emitLine("```");
        }
    }

    public void addToList(Class<?> clazz) {
        if (this.isSpecialType(clazz) || clazz.isEnum() || (clazz.getModifiers() & 0x400) != 0) {
            return;
        }
        this.driver.addPduToDocument(clazz);
    }

    private <T> T getSample(Class<T> clazz) {
        return this.getSample(clazz, 0);
    }

    private <T> T getSample(Class<T> clazz, int index) {
        Object sample = null;
        List<? extends Object> sampleList = this.samples.get(clazz);
        if (sampleList == null) {
            sampleList = new ArrayList<Object>();
            this.samples.put(clazz, sampleList);
        }
        while (index >= sampleList.size()) {
            sampleList.add(this.makeSample(clazz, index));
        }
        sample = sampleList.get(index);
        return (T)sample;
    }

    private <T> T makeSample(Class<T> clazz, int index) {
        T sample = null;
        try {
            sample = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.driver.printToConsole("exception creating sample: " + e.getMessage());
            return sample;
        }
        List<Field> fields = this.getAllFields(clazz);
        for (Field field : fields) {
            if (this.fieldIsStatic(field)) continue;
            ArrayList<Object> value = null;
            Description descriptionAnnotation = field.getAnnotation(Description.class);
            Class<?> listType = this.getListType(field);
            if (listType != null) {
                Integer numberOfItems = 0;
                if (descriptionAnnotation != null) {
                    numberOfItems = descriptionAnnotation.numberOfSamplesInList();
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(numberOfItems);
                for (int i = 0; i < numberOfItems; ++i) {
                    Object listItem = this.getFieldSample(listType, descriptionAnnotation, i);
                    arrayList.add(listItem);
                }
                value = arrayList;
            } else {
                Class<?> fieldType = field.getType();
                value = this.getFieldSample(fieldType, descriptionAnnotation, index);
            }
            try {
                field.setAccessible(true);
                field.set(sample, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.driver.printToConsole("exception assigning value to sample: " + e.getMessage());
            }
        }
        return sample;
    }

    private boolean fieldIsStatic(Field field) {
        int modifiers = field.getModifiers();
        boolean isStatic = (modifiers & 8) != 0;
        return isStatic;
    }

    private Object getFieldSample(Class<?> fieldType, Description descriptionAnnotation, int index) {
        Enum value = null;
        if (this.isSpecialType(fieldType)) {
            String sampleString;
            if (descriptionAnnotation != null && (sampleString = this.getSampleString(descriptionAnnotation, index)) != null) {
                TypeParser<?> typeParser = this.specialTypes.get(fieldType);
                try {
                    value = (Enum)typeParser.parse(sampleString);
                }
                catch (NumberFormatException e) {
                    System.err.println("NumberFormatException parsing sample: " + sampleString + " for " + fieldType.getCanonicalName() + " : " + descriptionAnnotation);
                    throw e;
                }
            }
        } else if (fieldType.isEnum()) {
            String enumName = this.getSampleString(descriptionAnnotation, index);
            if (enumName != null) {
                Enum[] enumConstants = (Enum[])fieldType.getEnumConstants();
                for (int i = 0; i < enumConstants.length; ++i) {
                    Enum enumConstant = enumConstants[i];
                    if (!enumConstant.name().equals(enumName)) continue;
                    value = enumConstant;
                    break;
                }
            }
        } else {
            Class sampleClass = fieldType;
            if (descriptionAnnotation != null) {
                Class[] sampleClasses = descriptionAnnotation.sampleClasses();
                int sampleClassesLength = sampleClasses.length;
                if (sampleClasses != null && sampleClassesLength > 0) {
                    int sampleIndex = index;
                    if (sampleIndex >= sampleClassesLength) {
                        sampleIndex = sampleClassesLength - 1;
                    }
                    sampleClass = sampleClasses[sampleIndex];
                    this.addToList(sampleClass);
                }
            }
            value = (Enum)this.getSample(sampleClass, index);
        }
        return value;
    }

    private String getSampleString(Description descriptionAnnotation, int sampleIndex) {
        String sampleString = null;
        String[] samples = descriptionAnnotation.sample();
        if (samples != null) {
            if (sampleIndex >= samples.length) {
                sampleIndex = samples.length - 1;
            }
            if (sampleIndex >= 0) {
                sampleString = samples[sampleIndex];
            }
        }
        return sampleString;
    }

    private boolean isSpecialType(Class<?> clazz) {
        return this.specialTypes.containsKey(clazz);
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] declaredFields = clazz.getDeclaredFields();
        fields.addAll(Arrays.asList(declaredFields));
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null && !Object.class.equals(superclass); superclass = superclass.getSuperclass()) {
            declaredFields = superclass.getDeclaredFields();
            fields.addAll(Arrays.asList(declaredFields));
        }
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            if (field.getAnnotation(Deprecated.class) != null) {
                fields.remove(i);
                --i;
                continue;
            }
            int modifiers = field.getModifiers();
            if ((modifiers & 0x80) == 0) continue;
            fields.remove(i);
            --i;
        }
        return fields;
    }

    private Class<?> getListType(Field field) {
        Type typeOfField = field.getGenericType();
        Class<?> listType = this.getListType(typeOfField);
        return listType;
    }

    private Class<?> getListType(Type type) {
        Class<?> listType = null;
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type rawType = parameterizedType.getRawType();
        if (rawType == null) {
            return null;
        }
        if (rawType.equals(List.class)) {
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments == null || actualTypeArguments.length != 1) {
                return null;
            }
            Type actualTypeArgument = actualTypeArguments[0];
            if (actualTypeArgument == null || !(actualTypeArgument instanceof Class)) {
                return null;
            }
            listType = (Class<?>)actualTypeArgument;
            return listType;
        }
        if (!(type instanceof Class)) {
            return null;
        }
        Class clazz = (Class)type;
        Type genericSuperclazz = clazz.getGenericSuperclass();
        while (genericSuperclazz != null) {
            listType = this.getListType(genericSuperclazz);
            if (listType != null) {
                return listType;
            }
            if (!(genericSuperclazz instanceof Class)) break;
            clazz = (Class)genericSuperclazz;
            genericSuperclazz = clazz.getGenericSuperclass();
        }
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        for (int i = 0; i < genericInterfaces.length; ++i) {
            Type interfaze = genericInterfaces[i];
            listType = this.getListType(interfaze);
            if (listType == null) continue;
            return listType;
        }
        return null;
    }

    private void emit(String text) {
        this.driver.emit(text);
    }

    private void emitLine() {
        this.driver.emitLine();
    }

    private void emitLine(String text) {
        this.driver.emitLine(text);
    }

    private static class StringParser
    implements TypeParser<String> {
        private StringParser() {
        }

        @Override
        public String parse(String string) {
            return string;
        }
    }

    private static class VoidParser
    implements TypeParser<Void> {
        private VoidParser() {
        }

        @Override
        public Void parse(String string) {
            return null;
        }
    }

    private static class DoubleParser
    implements TypeParser<Double> {
        private DoubleParser() {
        }

        @Override
        public Double parse(String string) {
            return Double.valueOf(string);
        }
    }

    private static class FloatParser
    implements TypeParser<Float> {
        private FloatParser() {
        }

        @Override
        public Float parse(String string) {
            return Float.valueOf(string);
        }
    }

    private static class LongParser
    implements TypeParser<Long> {
        private LongParser() {
        }

        @Override
        public Long parse(String string) {
            return Long.valueOf(string);
        }
    }

    private static class IntegerParser
    implements TypeParser<Integer> {
        private IntegerParser() {
        }

        @Override
        public Integer parse(String string) {
            return Integer.valueOf(string);
        }
    }

    private static class ShortParser
    implements TypeParser<Short> {
        private ShortParser() {
        }

        @Override
        public Short parse(String string) {
            return Short.valueOf(string);
        }
    }

    private static class ByteParser
    implements TypeParser<Byte> {
        private ByteParser() {
        }

        @Override
        public Byte parse(String string) {
            return Byte.valueOf(string);
        }
    }

    private static class CharacterParser
    implements TypeParser<Character> {
        private CharacterParser() {
        }

        @Override
        public Character parse(String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            return Character.valueOf(string.charAt(0));
        }
    }

    private static class BooleanParser
    implements TypeParser<Boolean> {
        private BooleanParser() {
        }

        @Override
        public Boolean parse(String string) {
            return Boolean.valueOf(string);
        }
    }

    private static interface TypeParser<T> {
        public T parse(String var1);
    }
}

