/*
 * Decompiled with CFR 0.152.
 */
package com.yepher.jsondoc.helpers;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yepher.jsondoc.helpers.EnumeratedSubclasses;
import com.yepher.jsondoc.helpers.SubclassEnumeration;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EnumeratedSubclassAdapterFactory
implements TypeAdapterFactory {
    private Map<Class<?>, EnumeratedSubclassAdapter<?>> adapters = new ConcurrentHashMap();

    public synchronized <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class clazz = type.getRawType();
        if (clazz.isPrimitive()) {
            return null;
        }
        boolean hasOurInterface = false;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> iface = interfaces[i];
                if (!iface.equals(EnumeratedSubclasses.class)) continue;
                hasOurInterface = true;
                break;
            }
            if (hasOurInterface) break;
            clazz = clazz.getSuperclass();
        }
        if (!hasOurInterface) {
            return null;
        }
        Method staticMethod = null;
        try {
            staticMethod = clazz.getDeclaredMethod("getEnumerationValues", null);
        }
        catch (Exception e) {
            return null;
        }
        Enum[] enumerationValues = null;
        try {
            enumerationValues = (Enum[])staticMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
        if (enumerationValues.length == 0) {
            return null;
        }
        if (!(enumerationValues[0] instanceof SubclassEnumeration)) {
            return null;
        }
        EnumeratedSubclassAdapter<Object> adapter = this.adapters.get(clazz);
        if (adapter == null) {
            TypeAdapter[] delegates = new TypeAdapter[enumerationValues.length];
            for (int i = 0; i < enumerationValues.length; ++i) {
                Enum enumerationValue = enumerationValues[i];
                delegates[i] = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(((SubclassEnumeration)((Object)enumerationValue)).getSubclass()));
            }
            adapter = new EnumeratedSubclassAdapter(enumerationValues, delegates);
            this.adapters.put(clazz, adapter);
        }
        return adapter;
    }

    private static class EnumeratedSubclassAdapter<T>
    extends TypeAdapter<T> {
        private final Enum<? extends SubclassEnumeration<?>>[] enumerationValues;
        private final TypeAdapter<T>[] delegates;

        private EnumeratedSubclassAdapter(Enum<? extends SubclassEnumeration<?>>[] enumerationValues, TypeAdapter<T>[] delegates) {
            this.enumerationValues = enumerationValues;
            this.delegates = delegates;
        }

        public void write(JsonWriter writer, T value) throws IOException {
            if (value == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject();
            Enum valueType = (Enum)((EnumeratedSubclasses)value).getSubclass();
            int index = -1;
            String string = null;
            string = ((SubclassEnumeration)((Object)valueType)).getTag();
            index = this.getIndexFromTag(string);
            if (index < 0 || index >= this.enumerationValues.length) {
                throw new RuntimeException("invalid sub-class [" + string + "]");
            }
            writer.name(string);
            TypeAdapter<T> delegate = this.delegates[index];
            delegate.write(writer, value);
            writer.endObject();
        }

        public T read(JsonReader reader) throws IOException {
            TypeAdapter<T> delegate = null;
            Object result = null;
            JsonToken nextTokenType = this.checkNextToken(reader, JsonToken.NULL, JsonToken.BEGIN_OBJECT);
            if (nextTokenType == JsonToken.NULL) {
                return null;
            }
            this.checkNextToken(reader, JsonToken.NAME);
            String string = reader.nextName();
            int index = -1;
            index = this.getIndexFromTag(string);
            if (index < 0 || index >= this.enumerationValues.length) {
                throw new RuntimeException("invalid sub-class [" + string + "]");
            }
            delegate = this.delegates[index];
            result = delegate.read(reader);
            this.checkNextToken(reader, JsonToken.END_OBJECT);
            return (T)result;
        }

        private int getIndexFromTag(String tag) {
            SubclassEnumeration enumerationValue;
            int index;
            for (index = 0; index < this.enumerationValues.length && !(enumerationValue = (SubclassEnumeration)((Object)this.enumerationValues[index])).getTag().contentEquals(tag); ++index) {
            }
            return index;
        }

        private JsonToken checkNextToken(JsonReader reader, JsonToken ... tokens) throws IOException {
            JsonToken nextToken = reader.peek();
            if (tokens != null && !Arrays.asList(tokens).contains(nextToken)) {
                StringBuilder builder = new StringBuilder(" expected: ");
                for (int i = 0; i < tokens.length; ++i) {
                    JsonToken token = tokens[i];
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(token.name());
                }
                builder.append("; got ").append(nextToken.name());
                throw new RuntimeException(builder.toString());
            }
            if (nextToken == JsonToken.NULL) {
                reader.nextNull();
            } else if (nextToken == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
            } else if (nextToken == JsonToken.END_OBJECT) {
                reader.endObject();
            }
            return nextToken;
        }
    }
}

