/*
 * Decompiled with CFR 0.152.
 */
package com.yevdo.jwildcard;

import com.yevdo.jwildcard.JWildcardRule;
import com.yevdo.jwildcard.JWildcardRules;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JWildcard {
    private static final JWildcardRule QUESTION_MARK_RULE = new JWildcardRule("?", ".");
    private static final JWildcardRule STAR_RULE = new JWildcardRule("*", ".*");
    private static final JWildcardRules DEFAULT_RULES = new JWildcardRules(new HashSet<JWildcardRule>(Arrays.asList(QUESTION_MARK_RULE, STAR_RULE)));

    private JWildcard() {
        throw new IllegalStateException("JWildcard is a utility class, and can't be instantiated");
    }

    public static String wildcardToRegex(String wildcard) {
        return JWildcard.wildcardToRegex(wildcard, DEFAULT_RULES, true);
    }

    public static String wildcardToRegex(String wildcard, boolean strict) {
        return JWildcard.wildcardToRegex(wildcard, DEFAULT_RULES, strict);
    }

    public static String wildcardToRegex(String wildcard, JWildcardRules rules, boolean strict) {
        return JWildcardToRegex.wildcardToRegex(wildcard, rules, strict);
    }

    public static boolean matches(String wildcard, String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text must not be null");
        }
        Pattern pattern = Pattern.compile(JWildcard.wildcardToRegex(wildcard));
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    private static class JWildcardRuleWithIndex {
        private final JWildcardRule rule;
        private final int index;

        JWildcardRuleWithIndex(JWildcardRule rule, int index) {
            this.rule = rule;
            this.index = index;
        }

        private JWildcardRule getRule() {
            return this.rule;
        }

        private int getIndex() {
            return this.index;
        }
    }

    private static class JWildcardToRegex {
        private JWildcardToRegex() {
        }

        private static String wildcardToRegex(String wildcard, JWildcardRules rules, boolean strict) {
            if (wildcard == null) {
                throw new IllegalArgumentException("Wildcard must not be null");
            }
            if (rules == null) {
                throw new IllegalArgumentException("Rules must not be null");
            }
            List<JWildcardRuleWithIndex> listOfOccurrences = JWildcardToRegex.getContainedWildcardPairsOrdered(wildcard, rules);
            String regex = JWildcardToRegex.getRegexString(wildcard, listOfOccurrences);
            if (strict) {
                return "^" + regex + "$";
            }
            return regex;
        }

        private static String getRegexString(String wildcard, List<JWildcardRuleWithIndex> listOfOccurrences) {
            StringBuilder regex = new StringBuilder();
            int cursor = 0;
            for (JWildcardRuleWithIndex jWildcardRuleWithIndex : listOfOccurrences) {
                int index = jWildcardRuleWithIndex.getIndex();
                if (index != 0) {
                    regex.append(Pattern.quote(wildcard.substring(cursor, index)));
                }
                regex.append(jWildcardRuleWithIndex.getRule().getTarget());
                cursor = index + jWildcardRuleWithIndex.getRule().getSource().length();
            }
            if (cursor <= wildcard.length() - 1) {
                regex.append(Pattern.quote(wildcard.substring(cursor, wildcard.length())));
            }
            return regex.toString();
        }

        private static List<JWildcardRuleWithIndex> getContainedWildcardPairsOrdered(String wildcard, JWildcardRules rules) {
            LinkedList<JWildcardRuleWithIndex> listOfOccurrences = new LinkedList<JWildcardRuleWithIndex>();
            for (JWildcardRule jWildcardRuleWithIndex : rules.getRules()) {
                int index = -1;
                do {
                    if ((index = wildcard.indexOf(jWildcardRuleWithIndex.getSource(), index + 1)) <= -1) continue;
                    listOfOccurrences.add(new JWildcardRuleWithIndex(jWildcardRuleWithIndex, index));
                } while (index > -1);
            }
            listOfOccurrences.sort((o1, o2) -> {
                if (((JWildcardRuleWithIndex)o1).getIndex() == ((JWildcardRuleWithIndex)o2).getIndex()) {
                    return 0;
                }
                return ((JWildcardRuleWithIndex)o1).getIndex() > ((JWildcardRuleWithIndex)o2).getIndex() ? 1 : -1;
            });
            return listOfOccurrences;
        }
    }
}

