/*
 * Decompiled with CFR 0.152.
 */
package com.yevdo.jwildcard;

import com.yevdo.jwildcard.JWildcardRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JWildcardRules {
    private Set<JWildcardRule> rules;

    public JWildcardRules() {
        this.rules = new HashSet<JWildcardRule>();
    }

    public JWildcardRules(Set<JWildcardRule> rules) {
        this.rules = rules != null ? new HashSet<JWildcardRule>(rules) : new HashSet();
    }

    public boolean addRule(JWildcardRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Rule can't be null");
        }
        return this.rules.add(rule);
    }

    public boolean addRules(Collection<JWildcardRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("Rules list can't be null");
        }
        return this.rules.addAll(rules);
    }

    public boolean removeRule(JWildcardRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Rule to remove can't be null");
        }
        return this.rules.remove(rule);
    }

    public Set<JWildcardRule> getRules() {
        return this.rules;
    }
}

