/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.Yodo1MasDataAnalytics;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasAdMobRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;
    private boolean isRewarded;
    private final FullScreenContentCallback rewardShowListener = new FullScreenContentCallback(){

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardAdapter.this.callbackOpen();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            if (Yodo1MasAdMobRewardAdapter.this.isRewarded) {
                Yodo1MasAdMobRewardAdapter.this.callbackEarned();
                Yodo1MasAdMobRewardAdapter.this.isRewarded = false;
            }
            Yodo1MasAdMobRewardAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "reward", adError);
            Yodo1MasLog.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        public void onAdClicked() {
            Yodo1MasAdMobRewardAdapter.this.callbackClick();
        }
    };
    private final RewardedAdLoadCallback rewardLoadListener = new RewardedAdLoadCallback(){

        public void onAdLoaded(final @NonNull RewardedAd rewardedAd) {
            super.onAdLoaded((Object)rewardedAd);
            rewardedAd.setFullScreenContentCallback(Yodo1MasAdMobRewardAdapter.this.rewardShowListener);
            rewardedAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    double revenue = adValue.getValueMicros() / 1000000L;
                    String currency = adValue.getCurrencyCode();
                    String adSource = "";
                    AdapterResponseInfo loadedAdapterResponseInfo = rewardedAd.getResponseInfo().getLoadedAdapterResponseInfo();
                    if (loadedAdapterResponseInfo != null) {
                        adSource = loadedAdapterResponseInfo.getAdSourceName();
                    }
                    Yodo1MasDataAnalytics.trackAdRevenue((String)"admob", (String)adSource, (String)"", (String)rewardedAd.getAdUnitId(), (double)revenue, (String)currency);
                }
            });
            Yodo1MasAdMobRewardAdapter.this.rewardAd = rewardedAd;
            Yodo1MasAdMobRewardAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSource(Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasAdMobRewardAdapter.this.advertCode, (String)rewardedAd.getAdUnitId(), (boolean)true, (long)Yodo1MasAdMobRewardAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasAdMobRewardAdapter.this.callbackLoad(adRequestResult);
        }

        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "reward", (AdError)adError);
            Yodo1MasLog.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasAdMobRewardAdapter.this.advertCode, (String)Yodo1MasAdMobRewardAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasAdMobRewardAdapter.this.getAdLoadDuration(), (String)(adError.getCode() + ""), (String)adError.getMessage());
            Yodo1MasAdMobRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), adRequestResult);
        }
    };
    private final OnUserEarnedRewardListener userEarnedRewardListener = new OnUserEarnedRewardListener(){

        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = Yodo1MasAdMobUtils.getFormatString("onUserEarnedReward", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardAdapter.this.isRewarded = true;
        }
    };

    public Yodo1MasAdMobRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && super.isRewardAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        RewardedAd.load((Context)activity, (String)adId, (AdRequest)Yodo1MasAdMobAdapter.buildRequest(), (RewardedAdLoadCallback)this.rewardLoadListener);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.rewardAd.show(activity, this.userEarnedRewardListener);
            this.callbackOpen();
        }
    }
}

