package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;
import com.yodo1.mas.utils.Yodo1MasNetworkNameUtils;

public class Yodo1MasAdMobInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {
    private InterstitialAd interstitialAd;
    private final FullScreenContentCallback interstitialShowListener = new FullScreenContentCallback() {

        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "interstitial", interstitialAd.getAdUnitId(), interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "interstitial", interstitialAd.getAdUnitId(), interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            callbackClose();
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "interstitial", adError);
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        @Override
        public void onAdClicked() {
            callbackClick();
        }
    };
    private final InterstitialAdLoadCallback interstitialLoadListener = new InterstitialAdLoadCallback() {
        @Override
        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            super.onAdLoaded(interstitialAd);
            interstitialAd.setFullScreenContentCallback(interstitialShowListener);
            interstitialAd.setOnPaidEventListener(new OnPaidEventListener() {
                @Override
                public void onPaidEvent(@NonNull AdValue adValue) {
                    revenue = adValue.getValueMicros() * 0.000001;
                    price = revenue * 1000;
                    revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    callbackPayRevenue();
                }
            });

            Yodo1MasAdMobInterstitialAdapter.this.interstitialAd = interstitialAd;

            adSource = Yodo1MasAdMobUtils.getAdSourceName(interstitialAd.getResponseInfo());
            adNetworkUnitId = interstitialAd.getAdUnitId();
            adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(interstitialAd.getResponseInfo(), Yodo1MasAdMobInterstitialAdapter.this);

            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "interstitial", interstitialAd.getAdUnitId(), interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, interstitialAd.getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "interstitial", adError);
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), adError.getCode() + "", adError.getMessage());
            callbackError(error, adError.getCode(), adError.getMessage(), adRequestResult);
        }
    };

    public Yodo1MasAdMobInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        InterstitialAd.load(activity, adId, Yodo1MasAdMobAdapter.buildRequest(), interstitialLoadListener);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            interstitialAd.show(activity);
        }
    }
}
