package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;
import com.yodo1.mas.utils.Yodo1MasNetworkNameUtils;

public class Yodo1MasAdMobRewardAdapter extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;
    private boolean isRewarded;
    private final FullScreenContentCallback rewardShowListener = new FullScreenContentCallback() {
        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            if (isRewarded) {
                callbackEarned();
                isRewarded = false;
            }
            callbackClose();
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "reward", adError);
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        @Override
        public void onAdClicked() {
            callbackClick();
        }
    };
    private final RewardedAdLoadCallback rewardLoadListener = new RewardedAdLoadCallback() {
        @Override
        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            super.onAdLoaded(rewardedAd);
            rewardedAd.setFullScreenContentCallback(rewardShowListener);
            rewardedAd.setOnPaidEventListener(new OnPaidEventListener() {
                @Override
                public void onPaidEvent(@NonNull AdValue adValue) {
                    revenue = adValue.getValueMicros() * 0.000001;
                    price = revenue * 1000;
                    revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    callbackPayRevenue();
                }
            });
            Yodo1MasAdMobRewardAdapter.this.rewardAd = rewardedAd;

            adSource = Yodo1MasAdMobUtils.getAdSourceName(rewardAd.getResponseInfo());
            adNetworkUnitId = rewardAd.getAdUnitId();
            adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(rewardAd.getResponseInfo(), Yodo1MasAdMobRewardAdapter.this);

            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);

            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, rewardedAd.getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "reward", adError);
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");

            Yodo1MasAdRequestResultInfo adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), adError.getCode() + "", adError.getMessage());
            callbackError(error, adError.getCode(), adError.getMessage(), adRequestResult);
        }
    };
    private final OnUserEarnedRewardListener userEarnedRewardListener = new OnUserEarnedRewardListener() {
        @Override
        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = Yodo1MasAdMobUtils.getFormatString("onUserEarnedReward", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            isRewarded = true;
        }
    };

    public Yodo1MasAdMobRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && super.isRewardAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        RewardedAd.load(activity, adId, Yodo1MasAdMobAdapter.buildRequest(), rewardLoadListener);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            rewardAd.show(activity, userEarnedRewardListener);
            callbackOpen();
        }
    }
}
