package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasAdMobAppOpenAdapter extends Yodo1MasAppOpenAdapterBase {

    private AppOpenAd appOpenAd;
    private final FullScreenContentCallback appOpenAdShowListener = new FullScreenContentCallback() {
        @Override
        public void onAdClicked() {
            callbackClick();
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "appOpenAd", appOpenAd.getAdUnitId(), adSource);
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            callbackClose();
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "appOpenAd", adError);
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        @Override
        public void onAdImpression() {
            super.onAdImpression();
        }

        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "appOpenAd", appOpenAd.getAdUnitId(), adSource);
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }
    };
    private final AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadListener = new AppOpenAd.AppOpenAdLoadCallback() {
        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "appOpenAd", loadAdError);
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");

            if(Yodo1MasAdMobUtils.isAdmobMediation(advertCode)) {
                adRequestResult
                        = Yodo1MasAdRequestTrackUtil.getAdmobMediationAdRequestResult(Yodo1Mas.AdType.AppOpen
                        , advertCode, adSource, getAdUnitId(), false, getAdLoadDuration(), loadAdError.getCode() + "", loadAdError.getMessage());
            }
            else {
                adRequestResult
                        = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.AppOpen
                        , advertCode, getAdUnitId(), false, getAdLoadDuration(), loadAdError.getCode() + "", loadAdError.getMessage());
            }
            callbackError(error, loadAdError.getCode(), loadAdError.getMessage(), adRequestResult);
        }

        @Override
        public void onAdLoaded(@NonNull AppOpenAd appOpenAd) {
            super.onAdLoaded(appOpenAd);
            appOpenAd.setFullScreenContentCallback(appOpenAdShowListener);
            appOpenAd.setOnPaidEventListener(new OnPaidEventListener() {
                @Override
                public void onPaidEvent(@NonNull AdValue adValue) {
                    revenue = adValue.getValueMicros()  * 0.000001;
                    price = revenue * 1000;
                    revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    if(isMax) {
                        callbackPayRevenue();
                    }
                }
            });
            Yodo1MasAdMobAppOpenAdapter.this.appOpenAd = appOpenAd;

            adSource = Yodo1MasAdMobUtils.getAdSourceName(appOpenAd.getResponseInfo());
            adNetworkUnitId = appOpenAd.getAdUnitId();
            adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(appOpenAd.getResponseInfo(), Yodo1MasAdMobAppOpenAdapter.this);

            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "appOpenAd", appOpenAd.getAdUnitId(), adSource);
            Yodo1MasLog.d(TAG, message);

            if(Yodo1MasAdMobUtils.isAdmobMediation(advertCode)) {
                adRequestResult
                        = Yodo1MasAdRequestTrackUtil.getAdmobMediationAdRequestResult(Yodo1Mas.AdType.AppOpen
                        , advertCode, adSource, appOpenAd.getAdUnitId(), true, getAdLoadDuration(), null, null);
            } else {
                adRequestResult
                        = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.AppOpen
                        , advertCode, appOpenAd.getAdUnitId(), true, getAdLoadDuration(), null, null);
            }
            callbackLoad(adRequestResult);
        }
    };

    public Yodo1MasAdMobAppOpenAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isAppOpenAdLoaded() {
        return appOpenAd != null && super.isAppOpenAdLoaded();
    }

    @Override
    public void loadAppOpenAdvert(Activity activity) {
        super.loadAppOpenAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (appOpenStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadAppOpenAdvert, loading AppOpen ad...";
        Yodo1MasLog.d(TAG, message);
        trackLoadTime();
        appOpenStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        AppOpenAd.load(activity, adId, Yodo1MasAdMobAdapter.buildRequest(), appOpenAdLoadListener);
    }

    @Override
    public void showAppOpenAdvertFromActivity(Activity activity) {
        super.showAppOpenAdvertFromActivity(activity);
        if (isAppOpenAdLoaded()) {
            String message = "method: showAppOpenAdvert, show appOpen ad...";
            Yodo1MasLog.d(TAG, message);
            appOpenAd.show(activity);
        }
    }

}
