/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.ad.Yodo1MasAdAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import java.util.List;

public class Yodo1MasAdMobBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private AdView bannerAd;
    private boolean isMax;
    private final AdListener bannerListener = new AdListener(){

        public void onAdOpened() {
            String message = Yodo1MasAdMobUtils.getFormatString("onAdOpened", "banner", Yodo1MasAdMobBannerAdapter.this.bannerAd.getAdUnitId(), Yodo1MasAdMobBannerAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobBannerAdapter.this.callback(1001, Yodo1MasAdMobBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdClicked() {
            String message = Yodo1MasAdMobUtils.getFormatString("onAdClicked", "banner", Yodo1MasAdMobBannerAdapter.this.bannerAd.getAdUnitId(), Yodo1MasAdMobBannerAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
        }

        public void onAdClosed() {
            String message = Yodo1MasAdMobUtils.getFormatString("onAdClosed", "banner", Yodo1MasAdMobBannerAdapter.this.bannerAd.getAdUnitId(), Yodo1MasAdMobBannerAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.price = 0.0;
            Yodo1MasAdMobBannerAdapter.this.revenue = 0.0;
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobBannerAdapter.this.callback(1002, Yodo1MasAdMobBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobBannerAdapter.this.loadBannerAdvert();
            Yodo1MasAdMobBannerAdapter.this.adSource = "";
        }

        public void onAdLoaded() {
            super.onAdLoaded();
            Yodo1MasAdMobBannerAdapter.this.bannerAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    Yodo1MasAdMobBannerAdapter.this.revenue = (double)adValue.getValueMicros() * 1.0E-6;
                    Yodo1MasAdMobBannerAdapter.this.price = Yodo1MasAdMobBannerAdapter.this.revenue * 1000.0;
                    Yodo1MasAdMobBannerAdapter.this.revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    Yodo1MasAdMobBannerAdapter.this.callback(2002, "");
                }
            });
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAdMobBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasAdMobBannerAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSourceName(Yodo1MasAdMobBannerAdapter.this.bannerAd.getResponseInfo());
            Yodo1MasAdMobBannerAdapter.this.adNetworkUnitId = Yodo1MasAdMobBannerAdapter.this.bannerAd.getAdUnitId();
            Yodo1MasAdMobBannerAdapter.this.adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(Yodo1MasAdMobBannerAdapter.this.bannerAd.getResponseInfo(), (Yodo1MasAdAdapterBase)Yodo1MasAdMobBannerAdapter.this);
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "banner", Yodo1MasAdMobBannerAdapter.this.bannerAd.getAdUnitId(), Yodo1MasAdMobBannerAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasAdMobBannerAdapter.this.callback(1003, Yodo1MasAdMobBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobBannerAdapter.this.callbackAdapterState();
        }

        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "banner", (AdError)adError);
            Yodo1MasLog.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.price = 0.0;
            Yodo1MasAdMobBannerAdapter.this.revenue = 0.0;
            Yodo1MasAdMobBannerAdapter.this.adSource = "";
            Yodo1MasAdMobBannerAdapter.this.trackAdRequestFailed(adError.getCode(), adError.getMessage());
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasAdMobBannerAdapter.this.isMax()) {
                Yodo1MasAdMobBannerAdapter.this.handleLoadFailedCallback(message);
                Yodo1MasAdMobBannerAdapter.this.nextBanner();
                Yodo1MasAdMobBannerAdapter.this.loadBannerAdvertDelayed();
            } else if (Yodo1MasAdMobBannerAdapter.this.isLastPlacement()) {
                Yodo1MasAdMobBannerAdapter.this.handleLoadFailedCallback(message);
            } else {
                Yodo1MasAdMobBannerAdapter.this.nextBanner();
                Yodo1MasAdMobBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }
    };

    public Yodo1MasAdMobBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isMax() {
        return this.isMax;
    }

    public void setMax(boolean max) {
        this.isMax = max;
    }

    public boolean isBannerAdvertLoaded() {
        return this.bannerAd != null && !TextUtils.isEmpty((CharSequence)this.bannerAd.getAdUnitId()) && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!this.isMax() && adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            if (this.bannerAd == null || !adId.adId.equals(this.bannerAd.getAdUnitId())) {
                this.bannerAd = new AdView((Context)activity);
                this.bannerAd.setAdListener(this.bannerListener);
                this.setBannerSize(activity, this.bannerAd);
                this.bannerAd.setAdUnitId(adId.adId);
            }
            if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Yodo1MasLog.d((String)this.TAG, (String)message);
                this.bannerAd.loadAd(Yodo1MasAdMobAdapter.buildRequest());
                this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
                this.logAdIdInfo(adId);
            }
        }
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return true;
    }

    private void setBannerSize(Activity activity, AdView bannerAd) {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Yodo1MasLog.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            bannerAd.setAdSize(AdSize.BANNER);
        } else if (Yodo1MasBannerAdSize.LargeBanner == size) {
            bannerAd.setAdSize(AdSize.LARGE_BANNER);
        } else if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            bannerAd.setAdSize(AdSize.MEDIUM_RECTANGLE);
        } else if (Yodo1MasBannerAdSize.SmartBanner == size) {
            bannerAd.setAdSize(AdSize.SMART_BANNER);
        } else if (Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            bannerAd.setAdSize(this.getAdSize(activity));
        }
    }

    private AdSize getAdSize(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;
        int adWidth = (int)(widthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)activity, (int)adWidth);
    }

    private void handleLoadFailedCallback(String message) {
        Yodo1MasError error = new Yodo1MasError(-600202, this.TAG + ":{" + message + "}");
        this.callback(error);
        this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
        this.callbackAdapterState();
    }
}

