/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.nativead.NativeAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.ad.Yodo1MasAdAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import com.yodo1.mas.mediation.admob.nativetemplate.Yodo1MasAdmobNativeTemplateStyle;
import com.yodo1.mas.mediation.admob.nativetemplate.Yodo1MasAdmobNativeTemplateView;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import java.util.List;

public class Yodo1MasAdmobNativeAdapter
extends Yodo1MasNativeAdapterBase {
    private NativeAd ad;
    private Yodo1MasAdmobNativeTemplateView templateView;
    private Activity activity;
    private final NativeAd.OnNativeAdLoadedListener loadListener = new NativeAd.OnNativeAdLoadedListener(){

        public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
            Yodo1MasAdmobNativeAdapter.this.ad = nativeAd;
            Yodo1MasAdmobNativeAdapter.this.ad.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    Yodo1MasAdmobNativeAdapter.this.revenue = (double)adValue.getValueMicros() * 1.0E-6;
                    Yodo1MasAdmobNativeAdapter.this.price = Yodo1MasAdmobNativeAdapter.this.revenue * 1000.0;
                    Yodo1MasAdmobNativeAdapter.this.revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    if (Yodo1MasAdmobNativeAdapter.this.isMax) {
                        Yodo1MasAdmobNativeAdapter.this.callbackPayRevenue();
                    }
                }
            });
            Yodo1MasAdmobNativeTemplateStyle styles = new Yodo1MasAdmobNativeTemplateStyle.Builder().build();
            Bundle extra = new Bundle();
            extra.putString("nativeSize", Yodo1MasAdmobNativeAdapter.this.adSize);
            extra.putInt("containerHeightPx", Yodo1MasAdmobNativeAdapter.this.containerHeightPx);
            extra.putInt("containerWidthPx", Yodo1MasAdmobNativeAdapter.this.containerWidthPx);
            Yodo1MasAdmobNativeAdapter.this.templateView = new Yodo1MasAdmobNativeTemplateView((Context)Yodo1MasAdmobNativeAdapter.this.activity, null, extra);
            Yodo1MasAdmobNativeAdapter.this.templateView.setStyles(styles);
            Yodo1MasAdmobNativeAdapter.this.templateView.setNativeAd(nativeAd);
            Yodo1MasAdmobNativeAdapter.this.nativeState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAdmobNativeAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSourceName(Yodo1MasAdmobNativeAdapter.this.ad.getResponseInfo());
            Yodo1MasAdmobNativeAdapter.this.adNetworkUnitId = Yodo1MasAdmobNativeAdapter.this.getAdUniId(false);
            Yodo1MasAdmobNativeAdapter.this.adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(Yodo1MasAdmobNativeAdapter.this.ad.getResponseInfo(), (Yodo1MasAdAdapterBase)Yodo1MasAdmobNativeAdapter.this);
            String message = Yodo1MasAdMobUtils.getFormatString("onNativeAdLoaded", "native", Yodo1MasAdmobNativeAdapter.this.adNetworkUnitId, Yodo1MasAdmobNativeAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
            Yodo1MasAdmobNativeAdapter.this.callbackLoad();
        }
    };
    private final AdListener adListener = new AdListener(){

        public void onAdClicked() {
            super.onAdClicked();
            String message = "method: onAdClicked : ";
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
            Yodo1MasAdmobNativeAdapter.this.callbackClick();
        }

        public void onAdClosed() {
            super.onAdClosed();
            String message = "method: onAdClosed : ";
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = "method: onAdFailedToLoad: , error: " + loadAdError.toString();
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
            Yodo1MasAdmobNativeAdapter.this.price = 0.0;
            Yodo1MasAdmobNativeAdapter.this.revenue = 0.0;
            Yodo1MasAdmobNativeAdapter.this.adSource = "";
            Yodo1MasAdmobNativeAdapter.this.nativeState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, message);
            Yodo1MasAdmobNativeAdapter.this.callbackError(error, loadAdError.getCode() + "", loadAdError.getMessage());
        }

        public void onAdImpression() {
            super.onAdImpression();
            String message = "method: onAdImpression : ";
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
            Yodo1MasAdmobNativeAdapter.this.callbackOpen();
        }

        public void onAdLoaded() {
            super.onAdLoaded();
            String message = "method: onAdLoaded : ";
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
        }

        public void onAdOpened() {
            super.onAdOpened();
            String message = "method: onAdOpened : ";
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
        }

        public void onAdSwipeGestureClicked() {
            super.onAdSwipeGestureClicked();
            String message = "method: onAdSwipeGestureClicked : ";
            Yodo1MasLog.d((String)Yodo1MasAdmobNativeAdapter.this.TAG, (String)message);
        }
    };

    public Yodo1MasAdmobNativeAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public void loadNativeAd(Activity activity) {
        super.loadNativeAd(activity);
        this.loadNativeAd_(activity);
    }

    private void loadNativeAd_(Activity activity) {
        if (activity == null) {
            return;
        }
        String unitId = this.getAdUniId(false);
        if (TextUtils.isEmpty((CharSequence)unitId)) {
            return;
        }
        String message = "method: loadNativeAdvert, loading native ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.activity = activity;
        this.nativeState = Yodo1MasAdapterBase.AdvertState.LOADING;
        AdLoader loader = new AdLoader.Builder((Context)activity, unitId).forNativeAd(this.loadListener).withAdListener(this.adListener).build();
        loader.loadAd(Yodo1MasAdMobAdapter.buildRequest());
    }

    public void loadNextNativeAd() {
        String unitId;
        super.loadNextNativeAd();
        if (this.activity == null) {
            return;
        }
        String preUnitId = this.getAdUniId(false);
        if (TextUtils.equals((CharSequence)preUnitId, (CharSequence)(unitId = this.getAdUniId(true)))) {
            return;
        }
        this.loadNativeAd_(this.activity);
    }

    public View getNativeAdView() {
        return this.templateView;
    }

    public void destroyNative() {
        super.destroyNative();
        if (this.ad != null) {
            this.ad.destroy();
        }
    }
}

