/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.ad.Yodo1MasAdAdapterBase;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasAdMobAppOpenAdapter
extends Yodo1MasAppOpenAdapterBase {
    private AppOpenAd appOpenAd;
    private final FullScreenContentCallback appOpenAdShowListener = new FullScreenContentCallback(){

        public void onAdClicked() {
            Yodo1MasAdMobAppOpenAdapter.this.callbackClick();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "appOpenAd", Yodo1MasAdMobAppOpenAdapter.this.appOpenAd.getAdUnitId(), Yodo1MasAdMobAppOpenAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAppOpenAdapter.this.price = 0.0;
            Yodo1MasAdMobAppOpenAdapter.this.revenue = 0.0;
            Yodo1MasAdMobAppOpenAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "appOpenAd", adError);
            Yodo1MasLog.d((String)Yodo1MasAdMobAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAppOpenAdapter.this.price = 0.0;
            Yodo1MasAdMobAppOpenAdapter.this.revenue = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobAppOpenAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAppOpenAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        public void onAdImpression() {
            super.onAdImpression();
        }

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "appOpenAd", Yodo1MasAdMobAppOpenAdapter.this.appOpenAd.getAdUnitId(), Yodo1MasAdMobAppOpenAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAppOpenAdapter.this.callbackOpen();
        }
    };
    private final AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadListener = new AppOpenAd.AppOpenAdLoadCallback(){

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "appOpenAd", (AdError)loadAdError);
            Yodo1MasLog.d((String)Yodo1MasAdMobAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAppOpenAdapter.this.price = 0.0;
            Yodo1MasAdMobAppOpenAdapter.this.revenue = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobAppOpenAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAppOpenAdapter.this.adRequestResult = Yodo1MasAdMobUtils.isAdmobMediation(Yodo1MasAdMobAppOpenAdapter.this.advertCode) ? Yodo1MasAdRequestTrackUtil.getAdmobMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.AppOpen, (String)Yodo1MasAdMobAppOpenAdapter.this.advertCode, (String)Yodo1MasAdMobAppOpenAdapter.this.adSource, (String)Yodo1MasAdMobAppOpenAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasAdMobAppOpenAdapter.this.getAdLoadDuration(), (String)(loadAdError.getCode() + ""), (String)loadAdError.getMessage()) : Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.AppOpen, (String)Yodo1MasAdMobAppOpenAdapter.this.advertCode, (String)Yodo1MasAdMobAppOpenAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasAdMobAppOpenAdapter.this.getAdLoadDuration(), (String)(loadAdError.getCode() + ""), (String)loadAdError.getMessage());
            Yodo1MasAdMobAppOpenAdapter.this.callbackError(error, loadAdError.getCode(), loadAdError.getMessage(), Yodo1MasAdMobAppOpenAdapter.this.adRequestResult);
        }

        public void onAdLoaded(@NonNull AppOpenAd appOpenAd) {
            super.onAdLoaded((Object)appOpenAd);
            appOpenAd.setFullScreenContentCallback(Yodo1MasAdMobAppOpenAdapter.this.appOpenAdShowListener);
            appOpenAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    Yodo1MasAdMobAppOpenAdapter.this.revenue = (double)adValue.getValueMicros() * 1.0E-6;
                    Yodo1MasAdMobAppOpenAdapter.this.price = Yodo1MasAdMobAppOpenAdapter.this.revenue * 1000.0;
                    Yodo1MasAdMobAppOpenAdapter.this.revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    if (Yodo1MasAdMobAppOpenAdapter.this.isMax) {
                        Yodo1MasAdMobAppOpenAdapter.this.callbackPayRevenue();
                    }
                }
            });
            Yodo1MasAdMobAppOpenAdapter.this.appOpenAd = appOpenAd;
            Yodo1MasAdMobAppOpenAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSourceName(appOpenAd.getResponseInfo());
            Yodo1MasAdMobAppOpenAdapter.this.adNetworkUnitId = appOpenAd.getAdUnitId();
            Yodo1MasAdMobAppOpenAdapter.this.adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(appOpenAd.getResponseInfo(), (Yodo1MasAdAdapterBase)Yodo1MasAdMobAppOpenAdapter.this);
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "appOpenAd", appOpenAd.getAdUnitId(), Yodo1MasAdMobAppOpenAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAppOpenAdapter.this.adRequestResult = Yodo1MasAdMobUtils.isAdmobMediation(Yodo1MasAdMobAppOpenAdapter.this.advertCode) ? Yodo1MasAdRequestTrackUtil.getAdmobMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.AppOpen, (String)Yodo1MasAdMobAppOpenAdapter.this.advertCode, (String)Yodo1MasAdMobAppOpenAdapter.this.adSource, (String)appOpenAd.getAdUnitId(), (boolean)true, (long)Yodo1MasAdMobAppOpenAdapter.this.getAdLoadDuration(), null, null) : Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.AppOpen, (String)Yodo1MasAdMobAppOpenAdapter.this.advertCode, (String)appOpenAd.getAdUnitId(), (boolean)true, (long)Yodo1MasAdMobAppOpenAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasAdMobAppOpenAdapter.this.callbackLoad(Yodo1MasAdMobAppOpenAdapter.this.adRequestResult);
        }
    };

    public Yodo1MasAdMobAppOpenAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isAppOpenAdLoaded() {
        return this.appOpenAd != null && super.isAppOpenAdLoaded();
    }

    public void loadAppOpenAdvert(Activity activity) {
        super.loadAppOpenAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.appOpenStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadAppOpenAdvert, loading AppOpen ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.trackLoadTime();
        this.appOpenStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        AppOpenAd.load((Context)activity, (String)adId, (AdRequest)Yodo1MasAdMobAdapter.buildRequest(), (AppOpenAd.AppOpenAdLoadCallback)this.appOpenAdLoadListener);
    }

    public void showAppOpenAdvertFromActivity(Activity activity) {
        super.showAppOpenAdvertFromActivity(activity);
        if (this.isAppOpenAdLoaded()) {
            String message = "method: showAppOpenAdvert, show appOpen ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.appOpenAd.show(activity);
        }
    }
}

