/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob.nativetemplate;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.mediation.admob.R;
import com.yodo1.mas.mediation.admob.nativetemplate.Yodo1MasAdmobNativeTemplateStyle;
import com.yodo1.mas.nativeads.Yodo1MasNativeSize;
import com.yodo1.mas.utils.Yodo1MasNativeUtil;

public class Yodo1MasAdmobNativeTemplateView
extends FrameLayout {
    private static final String TAG = "Yodo1MasAdmobNativeTemplateView";
    private int templateType;
    private Yodo1MasAdmobNativeTemplateStyle styles;
    private NativeAd nativeAd;
    private NativeAdView nativeAdView;
    private TextView primaryView;
    private TextView secondaryView;
    private RatingBar ratingBar;
    private TextView tertiaryView;
    private ImageView iconView;
    private MediaView mediaView;
    private Button callToActionView;
    private ConstraintLayout background;
    private String nativeSize;
    private int containerHeightPx;
    private int containerWidthPx;
    private static final String MEDIUM_TEMPLATE = "medium_template";
    private static final String SMALL_TEMPLATE = "small_template";

    public Yodo1MasAdmobNativeTemplateView(Context context) {
        super(context);
    }

    public Yodo1MasAdmobNativeTemplateView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, null);
    }

    public Yodo1MasAdmobNativeTemplateView(Context context, @Nullable AttributeSet attrs, Bundle extra) {
        super(context, attrs);
        if (extra.containsKey("nativeSize")) {
            this.nativeSize = extra.getString("nativeSize");
        }
        if (extra.containsKey("containerHeightPx")) {
            this.containerHeightPx = extra.getInt("containerHeightPx", 0);
        }
        if (extra.containsKey("containerWidthPx")) {
            this.containerWidthPx = extra.getInt("containerWidthPx", 0);
        }
        Yodo1MasLog.d((String)TAG, (String)("In constructor method nativeSize: " + this.nativeSize + " containerHeightPx: " + this.containerHeightPx + " containerWidthPx: " + this.containerWidthPx));
        this.initView(context, attrs, this.nativeSize);
    }

    public Yodo1MasAdmobNativeTemplateView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, null);
    }

    public Yodo1MasAdmobNativeTemplateView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs, null);
    }

    public void setStyles(Yodo1MasAdmobNativeTemplateStyle styles) {
        this.styles = styles;
        this.applyStyles();
    }

    public NativeAdView getNativeAdView() {
        return this.nativeAdView;
    }

    private void applyStyles() {
        ColorDrawable tertiaryBackground;
        ColorDrawable secondaryBackground;
        ColorDrawable primaryBackground;
        ColorDrawable ctaBackground;
        float tertiaryTextSize;
        float secondaryTextSize;
        float primaryTextSize;
        float ctaTextSize;
        Typeface ctaTypeface;
        Typeface tertiary;
        Typeface secondary;
        Typeface primary;
        ColorDrawable mainBackground = this.styles.getMainBackgroundColor();
        if (mainBackground != null) {
            this.background.setBackground((Drawable)mainBackground);
            if (this.primaryView != null) {
                this.primaryView.setBackground((Drawable)mainBackground);
            }
            if (this.secondaryView != null) {
                this.secondaryView.setBackground((Drawable)mainBackground);
            }
            if (this.tertiaryView != null) {
                this.tertiaryView.setBackground((Drawable)mainBackground);
            }
        }
        if ((primary = this.styles.getPrimaryTextTypeface()) != null && this.primaryView != null) {
            this.primaryView.setTypeface(primary);
        }
        if ((secondary = this.styles.getSecondaryTextTypeface()) != null && this.secondaryView != null) {
            this.secondaryView.setTypeface(secondary);
        }
        if ((tertiary = this.styles.getTertiaryTextTypeface()) != null && this.tertiaryView != null) {
            this.tertiaryView.setTypeface(tertiary);
        }
        if ((ctaTypeface = this.styles.getCallToActionTextTypeface()) != null && this.callToActionView != null) {
            this.callToActionView.setTypeface(ctaTypeface);
        }
        if (this.styles.getPrimaryTextTypefaceColor() != null && this.primaryView != null) {
            this.primaryView.setTextColor(this.styles.getPrimaryTextTypefaceColor().intValue());
        }
        if (this.styles.getSecondaryTextTypefaceColor() != null && this.secondaryView != null) {
            this.secondaryView.setTextColor(this.styles.getSecondaryTextTypefaceColor().intValue());
        }
        if (this.styles.getTertiaryTextTypefaceColor() != null && this.tertiaryView != null) {
            this.tertiaryView.setTextColor(this.styles.getTertiaryTextTypefaceColor().intValue());
        }
        if (this.styles.getCallToActionTypefaceColor() != null && this.callToActionView != null) {
            this.callToActionView.setTextColor(this.styles.getCallToActionTypefaceColor().intValue());
        }
        if ((ctaTextSize = this.styles.getCallToActionTextSize()) > 0.0f && this.callToActionView != null) {
            this.callToActionView.setTextSize(ctaTextSize);
        }
        if ((primaryTextSize = this.styles.getPrimaryTextSize()) > 0.0f && this.primaryView != null) {
            this.primaryView.setTextSize(primaryTextSize);
        }
        if ((secondaryTextSize = this.styles.getSecondaryTextSize()) > 0.0f && this.secondaryView != null) {
            this.secondaryView.setTextSize(secondaryTextSize);
        }
        if ((tertiaryTextSize = this.styles.getTertiaryTextSize()) > 0.0f && this.tertiaryView != null) {
            this.tertiaryView.setTextSize(tertiaryTextSize);
        }
        if ((ctaBackground = this.styles.getCallToActionBackgroundColor()) != null && this.callToActionView != null) {
            this.callToActionView.setBackground((Drawable)ctaBackground);
        }
        if ((primaryBackground = this.styles.getPrimaryTextBackgroundColor()) != null && this.primaryView != null) {
            this.primaryView.setBackground((Drawable)primaryBackground);
        }
        if ((secondaryBackground = this.styles.getSecondaryTextBackgroundColor()) != null && this.secondaryView != null) {
            this.secondaryView.setBackground((Drawable)secondaryBackground);
        }
        if ((tertiaryBackground = this.styles.getTertiaryTextBackgroundColor()) != null && this.tertiaryView != null) {
            this.tertiaryView.setBackground((Drawable)tertiaryBackground);
        }
        this.invalidate();
        this.requestLayout();
    }

    private boolean adHasOnlyStore(NativeAd nativeAd) {
        String store = nativeAd.getStore();
        String advertiser = nativeAd.getAdvertiser();
        return !TextUtils.isEmpty((CharSequence)store) && TextUtils.isEmpty((CharSequence)advertiser);
    }

    public void setNativeAd(NativeAd nativeAd) {
        String secondaryText;
        this.nativeAd = nativeAd;
        String store = nativeAd.getStore();
        String advertiser = nativeAd.getAdvertiser();
        String headline = nativeAd.getHeadline();
        String body = nativeAd.getBody();
        String cta = nativeAd.getCallToAction();
        Double starRating = nativeAd.getStarRating();
        NativeAd.Image icon = nativeAd.getIcon();
        this.nativeAdView.setCallToActionView((View)this.callToActionView);
        this.nativeAdView.setHeadlineView((View)this.primaryView);
        this.nativeAdView.setMediaView(this.mediaView);
        this.secondaryView.setVisibility(0);
        if (this.adHasOnlyStore(nativeAd)) {
            this.nativeAdView.setStoreView((View)this.secondaryView);
            secondaryText = store;
        } else if (!TextUtils.isEmpty((CharSequence)advertiser)) {
            this.nativeAdView.setAdvertiserView((View)this.secondaryView);
            secondaryText = advertiser;
        } else {
            secondaryText = "";
        }
        this.primaryView.setText((CharSequence)headline);
        this.callToActionView.setText((CharSequence)cta);
        if (starRating != null && starRating > 0.0) {
            this.secondaryView.setVisibility(8);
            this.ratingBar.setVisibility(0);
            this.ratingBar.setRating(starRating.floatValue());
            this.nativeAdView.setStarRatingView((View)this.ratingBar);
        } else {
            this.secondaryView.setText((CharSequence)secondaryText);
            this.secondaryView.setVisibility(0);
            this.ratingBar.setVisibility(8);
        }
        if (icon != null) {
            this.iconView.setVisibility(0);
            this.iconView.setImageDrawable(icon.getDrawable());
            this.nativeAdView.setIconView((View)this.iconView);
        } else {
            this.iconView.setVisibility(8);
        }
        if (this.tertiaryView != null) {
            this.tertiaryView.setText((CharSequence)body);
            this.nativeAdView.setBodyView((View)this.tertiaryView);
        }
        this.nativeAdView.setNativeAd(nativeAd);
        this.customSubViews();
    }

    public void destroyNativeAd() {
        this.nativeAd.destroy();
    }

    public String getTemplateTypeName() {
        if (this.templateType == R.layout.yodo1_mas_gnt_medium_template_view) {
            return MEDIUM_TEMPLATE;
        }
        if (this.templateType == R.layout.yodo1_mas_gnt_small_template_view) {
            return SMALL_TEMPLATE;
        }
        return "";
    }

    private void initView(Context context, AttributeSet attributeSet, String size) {
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.TemplateView, 0, 0);
        this.templateType = TextUtils.equals((CharSequence)size, (CharSequence)Yodo1MasNativeSize.SMALL.getValue()) ? R.layout.yodo1_mas_gnt_small_template_view : R.layout.yodo1_mas_gnt_medium_template_view;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(this.templateType, (ViewGroup)this);
        this.inflateView();
    }

    public void onFinishInflate() {
        super.onFinishInflate();
    }

    private void inflateView() {
        this.nativeAdView = (NativeAdView)this.findViewById(R.id.native_ad_view);
        this.primaryView = (TextView)this.findViewById(R.id.primary);
        this.secondaryView = (TextView)this.findViewById(R.id.secondary);
        this.tertiaryView = (TextView)this.findViewById(R.id.body);
        this.ratingBar = (RatingBar)this.findViewById(R.id.rating_bar);
        this.ratingBar.setEnabled(false);
        this.callToActionView = (Button)this.findViewById(R.id.cta);
        this.iconView = (ImageView)this.findViewById(R.id.icon);
        this.mediaView = (MediaView)this.findViewById(R.id.media_view);
        this.background = (ConstraintLayout)this.findViewById(R.id.background);
    }

    private void customSubViews() {
        this.primaryView.setSingleLine(true);
        this.primaryView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        this.primaryView.setMarqueeRepeatLimit(-1);
        this.primaryView.setFocusable(true);
        this.primaryView.setFocusableInTouchMode(true);
        this.primaryView.requestFocus();
        this.customeMediaViewSize();
    }

    private void customeMediaViewSize() {
        if (TextUtils.equals((CharSequence)this.nativeSize, (CharSequence)Yodo1MasNativeSize.SMALL.getValue()) || this.mediaView == null) {
            return;
        }
        if (this.containerHeightPx <= 0) {
            Yodo1MasLog.d((String)TAG, (String)"customeMediaViewSize containerHeightPx value <= 0, the method customeMediaViewSize will not work");
            return;
        }
        Context context = this.getContext();
        int middleHeight = Yodo1MasNativeUtil.dp2px((Context)context, (float)60.0f);
        int bodyHeight = this.getBodyTextViewHegiht(context);
        int ctaHeight = Yodo1MasNativeUtil.dp2px((Context)context, (float)35.0f);
        int spaceHeight = Yodo1MasNativeUtil.dp2px((Context)context, (float)70.0f);
        int containerHeight = this.containerHeightPx;
        int availableHeight = containerHeight - middleHeight - bodyHeight - ctaHeight - spaceHeight;
        Yodo1MasLog.d((String)TAG, (String)("customeMediaViewSize: containerHeightPx is: " + containerHeight + " availableHeight px = " + availableHeight));
        if (availableHeight < Yodo1MasNativeUtil.dp2px((Context)context, (float)100.0f)) {
            this.mediaView.setVisibility(8);
        } else {
            this.mediaView.setVisibility(0);
            ViewGroup.LayoutParams params = this.mediaView.getLayoutParams();
            if (this.mediaView.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                params.height = availableHeight;
                this.mediaView.setLayoutParams(params);
            }
        }
    }

    private int getBodyTextViewHegiht(Context context) {
        int bodyHeight = Yodo1MasNativeUtil.dp2px((Context)context, (float)20.0f);
        return bodyHeight;
    }

    private int calculateTextViewHeight(TextView textView, int availableWidth) {
        String text = textView.getText().toString();
        TextPaint textPaint = textView.getPaint();
        float textSize = textView.getTextSize();
        int maxLines = textView.getMaxLines();
        boolean includePadding = true;
        Rect bounds = new Rect();
        textPaint.getTextBounds(text, 0, text.length(), bounds);
        Paint.FontMetrics fm = textPaint.getFontMetrics();
        float textHeight = fm.descent - fm.ascent;
        if (availableWidth > 0) {
            int textWidth = (int)textPaint.measureText(text);
            int lineCount = (int)Math.ceil((float)textWidth / (float)availableWidth);
            if (maxLines > 0) {
                lineCount = Math.min(lineCount, maxLines);
            }
            textHeight = (float)lineCount * textHeight;
        }
        if (includePadding) {
            textHeight += (float)(textView.getPaddingTop() + textView.getPaddingBottom());
        }
        return (int)textHeight;
    }
}

