package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.nativead.NativeAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.ad.Yodo1MasAdPriceType;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.nativetemplate.Yodo1MasAdmobNativeTemplateStyle;
import com.yodo1.mas.mediation.admob.nativetemplate.Yodo1MasAdmobNativeTemplateView;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;

import java.util.List;

public class Yodo1MasAdmobNativeAdapter extends Yodo1MasNativeAdapterBase {

    private NativeAd ad;
    private Yodo1MasAdmobNativeTemplateView templateView;
    private Activity activity;

    private final NativeAd.OnNativeAdLoadedListener loadListener = new NativeAd.OnNativeAdLoadedListener() {
        @Override
        public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
            ad = nativeAd;
            ad.setOnPaidEventListener(new OnPaidEventListener() {
                @Override
                public void onPaidEvent(@NonNull AdValue adValue) {
                    revenue = adValue.getValueMicros() * 0.000001;
                    price = revenue * 1000;
                    revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    if(isMax) {
                        callbackPayRevenue();
                    }
                }
            });

            Yodo1MasAdmobNativeTemplateStyle styles = new
                    Yodo1MasAdmobNativeTemplateStyle.Builder()
//                    .withMainBackgroundColor(new ColorDrawable(Color.TRANSPARENT))
                    .build();
            Bundle extra = new Bundle();
            extra.putString("nativeSize", adSize);
            extra.putInt("containerHeightPx", containerHeightPx);
            extra.putInt("containerWidthPx", containerWidthPx);

            templateView = new Yodo1MasAdmobNativeTemplateView(activity, null, extra);
            templateView.setStyles(styles);
            templateView.setNativeAd(nativeAd);

            nativeState = Yodo1MasAdapterBase.AdvertState.LOADED;

            adSource = Yodo1MasAdMobUtils.getAdSourceName(ad.getResponseInfo());
            adNetworkUnitId = getAdUniId(false);
            adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(ad.getResponseInfo(), Yodo1MasAdmobNativeAdapter.this);

            String message = Yodo1MasAdMobUtils.getFormatString("onNativeAdLoaded", "native", adNetworkUnitId, adSource);
            Yodo1MasLog.d(TAG, message);

            callbackLoad();
        }
    };

    private final AdListener adListener = new AdListener() {
        @Override
        public void onAdClicked() {
            super.onAdClicked();
            String message = "method: onAdClicked : ";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdClosed() {
            super.onAdClosed();
            String message = "method: onAdClosed : ";
            Yodo1MasLog.d(TAG, message);
//            callbackClose();
        }

        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = "method: onAdFailedToLoad: " + ", error: " + loadAdError.toString();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            revenue = 0;
            adSource = "";
            nativeState = Yodo1MasAdapterBase.AdvertState.NONE;

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, message);
            callbackError(error, loadAdError.getCode() + "", loadAdError.getMessage());
        }

        @Override
        public void onAdImpression() {
            super.onAdImpression();
            String message = "method: onAdImpression : ";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdLoaded() {
            super.onAdLoaded();
            String message = "method: onAdLoaded : ";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdOpened() { // 广告被点击后会被多次调用
            super.onAdOpened();
            String message = "method: onAdOpened : ";
            Yodo1MasLog.d(TAG, message);
//            callbackOpen();
        }

        @Override
        public void onAdSwipeGestureClicked() {
            super.onAdSwipeGestureClicked();
            String message = "method: onAdSwipeGestureClicked : ";
            Yodo1MasLog.d(TAG, message);
        }
    };

    public Yodo1MasAdmobNativeAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public void loadNativeAd(Activity activity) {
        super.loadNativeAd(activity);
        loadNativeAd_(activity);
    }

    private void loadNativeAd_(Activity activity) {
        if (activity == null) return;

        String unitId = this.getAdUniId(false);
        if (TextUtils.isEmpty(unitId)) return;

        String message = "method: loadNativeAdvert, loading native ad...";
        Yodo1MasLog.d(TAG, message);

        this.activity = activity;
        nativeState = Yodo1MasAdapterBase.AdvertState.LOADING;

        AdLoader loader = new AdLoader.Builder(activity, unitId)
                .forNativeAd(loadListener)
                .withAdListener(adListener)
                .build();
        loader.loadAd(Yodo1MasAdMobAdapter.buildRequest());
    }

    @Override
    public void loadNextNativeAd() {
        super.loadNextNativeAd();
        if (activity == null) return;
        String preUnitId = this.getAdUniId(false);
        String unitId = this.getAdUniId(true);
        if (TextUtils.equals(preUnitId, unitId)) {
            return;
        }

        loadNativeAd_(activity);
    }

    @Override
    public View getNativeAdView() {
        return templateView;
    }

    @Override
    public void destroyNative() {
        super.destroyNative();
        if (ad != null) {
            ad.destroy();
        }
    }
}
