/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAppOpenAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobBannerAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobInterstitialAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobRewardAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobRewardedInterstitialAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdaptersPrivacy;
import com.yodo1.mas.mediation.admob.Yodo1MasAdmobNativeAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import java.util.Map;

public class Yodo1MasAdMobAdapter
extends Yodo1MasAdapterBase {
    public static AdRequest buildRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        Bundle extras = new Bundle();
        if (!Yodo1MasHelper.getInstance().isGDPRUserConsent()) {
            extras.putString("npa", "1");
        }
        if (Yodo1MasHelper.getInstance().isCCPADoNotSell()) {
            extras.putInt("rdp", 1);
        }
        return ((AdRequest.Builder)builder.addNetworkExtrasBundle(AdMobAdapter.class, extras)).build();
    }

    public String getAdvertCode() {
        return "admob";
    }

    public String networkName() {
        return "Google AdMob";
    }

    public String getSDKVersion() {
        return MobileAds.getVersion().toString();
    }

    public String getMediationVersion() {
        return "4.17.0";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (!this.isMax()) {
                MobileAds.disableMediationAdapterInitialization((Context)this.currentActivity);
            }
            this.preInitialize();
            this.updatePrivacy();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MobileAds.initialize((Context)Yodo1MasAdMobAdapter.this.currentActivity, initializationStatus -> {
                        Map statusMap = initializationStatus.getAdapterStatusMap();
                        for (String adapterClass : statusMap.keySet()) {
                            AdapterStatus status = (AdapterStatus)statusMap.get(adapterClass);
                            String desc = status != null ? status.getDescription() : " ";
                            String latency = status != null ? status.getLatency() + "" : " ";
                            Yodo1MasLog.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)String.format("Adapter name: %s, Description: %s, Latency: %s", adapterClass, desc, latency));
                        }
                        String message = "method: onInitializationComplete";
                        Yodo1MasLog.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
                        Yodo1MasAdMobAdapter.this.updatePrivacy();
                        if (callback != null) {
                            callback.onAdapterInitSuccessful(Yodo1MasAdMobAdapter.this.getAdvertCode());
                        }
                    });
                }
            }).start();
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        boolean init = super.isInitSDK();
        if (init) {
            String key = MobileAds.class.getName();
            AdapterStatus status = (AdapterStatus)MobileAds.getInitializationStatus().getAdapterStatusMap().get(key);
            init = status != null && status.getInitializationState() == AdapterStatus.State.READY;
        }
        return init;
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        SharedPreferences sharedPref = this.currentActivity.getPreferences(0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt("gad_npa", Yodo1MasHelper.getInstance().isGDPRUserConsent() ? 0 : 1);
        editor.putInt("gad_rdp", Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0);
        editor.apply();
        Yodo1MasAdaptersPrivacy.setAdColonyPrivacy();
        Yodo1MasAdaptersPrivacy.setAppLovinPrivacy((Context)this.currentActivity);
        Yodo1MasAdaptersPrivacy.setFacebookPrivacy();
        Yodo1MasAdaptersPrivacy.setFyberPrivacy();
        Yodo1MasAdaptersPrivacy.setInMobiPrivacy();
        Yodo1MasAdaptersPrivacy.setIronSourcePrivacy((Context)this.currentActivity);
        Yodo1MasAdaptersPrivacy.setTapjoyPrivacy();
        Yodo1MasAdaptersPrivacy.setUnityAdsPrivacy((Context)this.currentActivity);
        Yodo1MasAdaptersPrivacy.setVunglePrivacy();
        Yodo1MasAdaptersPrivacy.setMasMintegralPrivacy((Context)this.currentActivity);
    }

    private void preInitialize() {
        RequestConfiguration.Builder builder = MobileAds.getRequestConfiguration().toBuilder();
        int ageRestrictedUserTag = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted() ? 1 : 0;
        builder.setTagForChildDirectedTreatment(ageRestrictedUserTag);
        if (Yodo1MasHelper.getInstance().isCOPPAAgeRestricted()) {
            builder.setMaxAdContentRating("G");
        }
        RequestConfiguration requestConfiguration = builder.build();
        MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
    }

    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAdMobRewardAdapter.class;
    }

    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAdMobInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return Yodo1MasAdmobNativeAdapter.class;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAdMobBannerAdapter.class;
    }

    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return Yodo1MasAdMobRewardedInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return Yodo1MasAdMobAppOpenAdapter.class;
    }

    public Yodo1MasBannerAdapterBase getBannerAdapter() {
        Yodo1MasAdMobBannerAdapter bannerAdapter = (Yodo1MasAdMobBannerAdapter)super.getBannerAdapter();
        bannerAdapter.setMax(this.isMax());
        return bannerAdapter;
    }
}

