/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.ResponseInfo;
import com.yodo1.mas.ad.Yodo1MasAdAdapterBase;

public class Yodo1MasAdMobUtils {
    public static boolean isAdmobMediation(String advertCode) {
        return TextUtils.equals((CharSequence)advertCode, (CharSequence)"ADMOB");
    }

    private static String getAdSource(String adapterClassName) {
        if (TextUtils.isEmpty((CharSequence)adapterClassName) || !adapterClassName.contains(".")) {
            return "";
        }
        String[] array = adapterClassName.split("\\.");
        if (array.length > 1) {
            return array[array.length - 1];
        }
        return "";
    }

    public static String getFormatString(String methodName, String adType, String adUnitId, String adSource) {
        return String.format("method: %s, %s, ad unit id: %s, network name: %s", methodName, adType, adUnitId, adSource);
    }

    public static String getAdErrorFormatString(String methodName, String adType, AdError adError) {
        return String.format("method: %s, %s, error: %s", methodName, adType, adError.toString());
    }

    public static String getAdSourceName(ResponseInfo responseInfo) {
        if (responseInfo == null || responseInfo.getLoadedAdapterResponseInfo() == null) {
            return null;
        }
        String adSourceName = responseInfo.getLoadedAdapterResponseInfo().getAdSourceName();
        if (TextUtils.isEmpty((CharSequence)adSourceName)) {
            adSourceName = Yodo1MasAdMobUtils.getAdSource(responseInfo.getLoadedAdapterResponseInfo().getAdapterClassName());
        }
        return adSourceName;
    }

    public static String getAdSourceUnitId(ResponseInfo responseInfo, Yodo1MasAdAdapterBase adAdapterBase) {
        if (responseInfo == null || responseInfo.getLoadedAdapterResponseInfo() == null || adAdapterBase == null || adAdapterBase.adSource == null) {
            return null;
        }
        String adSourceUnitId = "";
        String adSourceName = adAdapterBase.adSource;
        Bundle credentials = responseInfo.getLoadedAdapterResponseInfo().getCredentials();
        if (adSourceName.toLowerCase().contains("admob")) {
            adSourceUnitId = adAdapterBase.adNetworkUnitId != null && adAdapterBase.adNetworkUnitId.length() > 0 ? adAdapterBase.adNetworkUnitId : "";
        } else {
            if (adSourceName.toLowerCase().contains("applovin")) {
                return adSourceUnitId;
            }
            if (credentials.containsKey("placementID")) {
                adSourceUnitId = credentials.getString("placementID");
            } else if (credentials.containsKey("ad_unit_id")) {
                adSourceUnitId = credentials.getString("ad_unit_id");
            } else if (credentials.containsKey("spotId")) {
                adSourceUnitId = credentials.getString("spotId");
            } else if (credentials.containsKey("zoneId")) {
                adSourceUnitId = credentials.getString("zoneId");
            } else if (credentials.containsKey("placementid")) {
                adSourceUnitId = credentials.getString("placementid");
            } else if (credentials.containsKey("placement_id")) {
                adSourceUnitId = credentials.getString("placement_id");
            } else if (credentials.containsKey("instanceId")) {
                adSourceUnitId = credentials.getString("instanceId");
            }
        }
        if (TextUtils.isEmpty((CharSequence)adSourceUnitId)) {
            adSourceUnitId = credentials.toString();
        }
        return adSourceUnitId;
    }

    public static String getRevenuePrecision(int precisionType) {
        String revenuePrecision = null;
        switch (precisionType) {
            case 0: {
                revenuePrecision = "unknown";
                break;
            }
            case 1: {
                revenuePrecision = "estimated";
                break;
            }
            case 2: {
                revenuePrecision = "publisher_defined";
                break;
            }
            case 3: {
                revenuePrecision = "exact";
            }
        }
        return revenuePrecision;
    }
}

