/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.ad.Yodo1MasAdAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasAdMobInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private InterstitialAd interstitialAd;
    private final FullScreenContentCallback interstitialShowListener = new FullScreenContentCallback(){

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "interstitial", Yodo1MasAdMobInterstitialAdapter.this.interstitialAd.getAdUnitId(), Yodo1MasAdMobInterstitialAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.callbackOpen();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "interstitial", Yodo1MasAdMobInterstitialAdapter.this.interstitialAd.getAdUnitId(), Yodo1MasAdMobInterstitialAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.price = 0.0;
            Yodo1MasAdMobInterstitialAdapter.this.revenue = 0.0;
            Yodo1MasAdMobInterstitialAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "interstitial", adError);
            Yodo1MasLog.d((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.price = 0.0;
            Yodo1MasAdMobInterstitialAdapter.this.revenue = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        public void onAdClicked() {
            Yodo1MasAdMobInterstitialAdapter.this.callbackClick();
        }
    };
    private final InterstitialAdLoadCallback interstitialLoadListener = new InterstitialAdLoadCallback(){

        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            super.onAdLoaded((Object)interstitialAd);
            interstitialAd.setFullScreenContentCallback(Yodo1MasAdMobInterstitialAdapter.this.interstitialShowListener);
            interstitialAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    Yodo1MasAdMobInterstitialAdapter.this.revenue = (double)adValue.getValueMicros() * 1.0E-6;
                    Yodo1MasAdMobInterstitialAdapter.this.price = Yodo1MasAdMobInterstitialAdapter.this.revenue * 1000.0;
                    Yodo1MasAdMobInterstitialAdapter.this.revenuePrecision = Yodo1MasAdMobUtils.getRevenuePrecision(adValue.getPrecisionType());
                    if (Yodo1MasAdMobInterstitialAdapter.this.isMax) {
                        Yodo1MasAdMobInterstitialAdapter.this.callbackPayRevenue();
                    }
                }
            });
            Yodo1MasAdMobInterstitialAdapter.this.interstitialAd = interstitialAd;
            Yodo1MasAdMobInterstitialAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSourceName(interstitialAd.getResponseInfo());
            Yodo1MasAdMobInterstitialAdapter.this.adNetworkUnitId = interstitialAd.getAdUnitId();
            Yodo1MasAdMobInterstitialAdapter.this.adSourceUnitId = Yodo1MasAdMobUtils.getAdSourceUnitId(interstitialAd.getResponseInfo(), (Yodo1MasAdAdapterBase)Yodo1MasAdMobInterstitialAdapter.this);
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "interstitial", interstitialAd.getAdUnitId(), Yodo1MasAdMobInterstitialAdapter.this.adSource);
            Yodo1MasLog.d((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.adRequestResult = Yodo1MasAdMobUtils.isAdmobMediation(Yodo1MasAdMobInterstitialAdapter.this.advertCode) ? Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasAdMobInterstitialAdapter.this.advertCode, (String)Yodo1MasAdMobInterstitialAdapter.this.adSource, (String)interstitialAd.getAdUnitId(), (boolean)true, (long)Yodo1MasAdMobInterstitialAdapter.this.getAdLoadDuration(), null, null) : Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasAdMobInterstitialAdapter.this.advertCode, (String)interstitialAd.getAdUnitId(), (boolean)true, (long)Yodo1MasAdMobInterstitialAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasAdMobInterstitialAdapter.this.callbackLoad(Yodo1MasAdMobInterstitialAdapter.this.adRequestResult);
        }

        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "interstitial", (AdError)adError);
            Yodo1MasLog.d((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.price = 0.0;
            Yodo1MasAdMobInterstitialAdapter.this.revenue = 0.0;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobInterstitialAdapter.this.adRequestResult = Yodo1MasAdMobUtils.isAdmobMediation(Yodo1MasAdMobInterstitialAdapter.this.advertCode) ? Yodo1MasAdRequestTrackUtil.getMediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasAdMobInterstitialAdapter.this.advertCode, (String)Yodo1MasAdMobInterstitialAdapter.this.adSource, (String)Yodo1MasAdMobInterstitialAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasAdMobInterstitialAdapter.this.getAdLoadDuration(), (String)(adError.getCode() + ""), (String)adError.getMessage()) : Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasAdMobInterstitialAdapter.this.advertCode, (String)Yodo1MasAdMobInterstitialAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasAdMobInterstitialAdapter.this.getAdLoadDuration(), (String)(adError.getCode() + ""), (String)adError.getMessage());
            Yodo1MasAdMobInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), Yodo1MasAdMobInterstitialAdapter.this.adRequestResult);
        }
    };

    public Yodo1MasAdMobInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && super.isInterstitialAdLoaded();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        InterstitialAd.load((Context)activity, (String)adId, (AdRequest)Yodo1MasAdMobAdapter.buildRequest(), (InterstitialAdLoadCallback)this.interstitialLoadListener);
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.interstitialAd.show(activity);
        }
    }
}

