/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.helper.model.Yodo1MasAdBuildConfig;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdaptersPrivacy;
import org.json.JSONObject;

public class Yodo1MasAdMobAdapter
extends Yodo1MasAdapterBase {
    private RewardedAd rewardAd;
    private InterstitialAd interstitialAd;
    private AdView bannerAd;
    private Yodo1MasAdapterBase.AdvertState interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    private Yodo1MasAdapterBase.AdvertState rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    private boolean isRewarded = false;
    private final RewardedAdLoadCallback rewardLoadListener = new RewardedAdLoadCallback(){

        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            super.onAdLoaded((Object)rewardedAd);
            String message = "method: onAdLoaded, reward, Mediation Adapter Class Name: " + rewardedAd.getResponseInfo().getMediationAdapterClassName();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAdMobAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
            Yodo1MasAdMobAdapter.this.rewardAd = rewardedAd;
            rewardedAd.setFullScreenContentCallback(Yodo1MasAdMobAdapter.this.rewardShowListener);
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = "method: onAdFailedToLoad, reward error: " + loadAdError.toString();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasAdMobAdapter.this.loadRewardAdvertDelayed();
        }
    };
    private final OnUserEarnedRewardListener userEarnedRewardListener = new OnUserEarnedRewardListener(){

        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = "method: onUserEarnedReward, reward item: " + rewardItem.getType();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.isRewarded = true;
        }
    };
    private final FullScreenContentCallback rewardShowListener = new FullScreenContentCallback(){

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = "method: onAdFailedToShowFullScreenContent, reward, error: " + adError.toString();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasAdMobAdapter.this.nextReward();
            Yodo1MasAdMobAdapter.this.loadRewardAdvert();
        }

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = "method: onAdShowedFullScreenContent, reward";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = "method: onAdDismissedFullScreenContent, reward";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            if (Yodo1MasAdMobAdapter.this.isRewarded) {
                Yodo1MasAdMobAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasAdMobAdapter.this.isRewarded = false;
            }
            Yodo1MasAdMobAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.loadRewardAdvert();
        }

        public void onAdImpression() {
            super.onAdImpression();
            String message = "method: onAdImpression, reward";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
        }
    };
    private final InterstitialAdLoadCallback interstitialLoadListener = new InterstitialAdLoadCallback(){

        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            super.onAdLoaded((Object)interstitialAd);
            String message = "method: onAdLoaded, interstitial, Mediation Adapter Class Name: " + interstitialAd.getResponseInfo().getMediationAdapterClassName();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAdMobAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
            Yodo1MasAdMobAdapter.this.interstitialAd = interstitialAd;
            interstitialAd.setFullScreenContentCallback(Yodo1MasAdMobAdapter.this.interstitialShowListener);
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = "method: onAdFailedToLoad, interstitial, error: " + loadAdError.toString();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasAdMobAdapter.this.nextInterstitial();
            Yodo1MasAdMobAdapter.this.loadInterstitialAdvertDelayed();
        }
    };
    private final FullScreenContentCallback interstitialShowListener = new FullScreenContentCallback(){

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = "method: onAdFailedToShowFullScreenContent, error: " + adError.toString();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasAdMobAdapter.this.nextInterstitial();
            Yodo1MasAdMobAdapter.this.loadInterstitialAdvert();
        }

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = "method: onAdShowedFullScreenContent, interstitial";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = "method: onAdDismissedFullScreenContent, interstitial";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.loadInterstitialAdvert();
        }

        public void onAdImpression() {
            super.onAdImpression();
            String message = "method: onAdImpression, interstitial";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
        }
    };
    private final AdListener bannerListener = new AdListener(){

        public void onAdOpened() {
            String message = "method: onAdOpened, banner";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobAdapter.this.callback(1001, Yodo1Mas.AdType.Banner, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdClicked() {
            String message = "method: onAdClicked, banner";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
        }

        public void onAdClosed() {
            String message = "method: onAdClosed, banner";
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobAdapter.this.callback(1002, Yodo1Mas.AdType.Banner, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.loadBannerAdvert();
        }

        public void onAdLoaded() {
            super.onAdLoaded();
            String message = "method: onAdLoaded, banner, Mediation Adapter Class Name: " + (Yodo1MasAdMobAdapter.this.bannerAd == null ? "" : Yodo1MasAdMobAdapter.this.bannerAd.getResponseInfo().getMediationAdapterClassName());
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAdMobAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            Yodo1MasAdMobAdapter.this.callback(1003, Yodo1Mas.AdType.Banner, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdFailedToLoad(LoadAdError adError) {
            String message = "method: onAdFailedToLoad, banner, error: " + adError.toString();
            Log.d((String)Yodo1MasAdMobAdapter.this.TAG, (String)message);
            Yodo1MasAdMobAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasAdMobAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
            Yodo1MasAdMobAdapter.this.nextBanner();
            Yodo1MasAdMobAdapter.this.loadBannerAdvertDelayed();
        }
    };

    public String getAdvertCode() {
        return "admob";
    }

    public String getSDKVersion() {
        return MobileAds.getVersionString();
    }

    public String getMediationVersion() {
        return "4.3.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (!this.isMax()) {
                MobileAds.disableMediationAdapterInitialization((Context)this.currentActivity);
            }
            this.preInitialize();
            MobileAds.initialize((Context)this.currentActivity, initializationStatus -> {
                String message = "method: onInitializationComplete, status: " + initializationStatus.getAdapterStatusMap();
                Log.d((String)this.TAG, (String)message);
                this.updatePrivacy();
                this.loadRewardAdvert();
                this.loadInterstitialAdvert();
                this.loadBannerAdvert();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
            });
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isMax() {
        return false;
    }

    public boolean isInitSDK() {
        boolean init = super.isInitSDK();
        if (init) {
            String key = MobileAds.class.getName();
            AdapterStatus status = (AdapterStatus)MobileAds.getInitializationStatus().getAdapterStatusMap().get(key);
            init = status != null && status.getInitializationState() == AdapterStatus.State.READY;
        }
        return init;
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        SharedPreferences sharedPref = this.currentActivity.getPreferences(0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt("gad_npa", Yodo1MasHelper.getInstance().isGDPRUserConsent() ? 0 : 1);
        editor.putInt("gad_rdp", Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0);
        editor.apply();
        Yodo1MasAdaptersPrivacy.setAdColonyPrivacy();
        Yodo1MasAdaptersPrivacy.setAppLovinPrivacy(this.currentActivity);
        Yodo1MasAdaptersPrivacy.setFacebookPrivacy();
        Yodo1MasAdaptersPrivacy.setFyberPrivacy();
        Yodo1MasAdaptersPrivacy.setInMobiPrivacy();
        Yodo1MasAdaptersPrivacy.setIronSourcePrivacy();
        Yodo1MasAdaptersPrivacy.setMyTargetPrivacy();
        Yodo1MasAdaptersPrivacy.setTapjoyPrivacy();
        Yodo1MasAdaptersPrivacy.setUnityAdsPrivacy(this.currentActivity);
        Yodo1MasAdaptersPrivacy.setVunglePrivacy();
    }

    private void preInitialize() {
        RequestConfiguration.Builder builder = MobileAds.getRequestConfiguration().toBuilder();
        if (Yodo1MasHelper.getInstance().isCOPPAAgeRestricted()) {
            builder.setTagForChildDirectedTreatment(1);
        }
        RequestConfiguration requestConfiguration = builder.build();
        MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return this.rewardAd != null && this.rewardState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && this.rewardState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            RewardedAd.load((Context)activity, (String)adId.adId, (AdRequest)this.buildRequest(), (RewardedAdLoadCallback)this.rewardLoadListener);
            this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.show(activity, this.userEarnedRewardListener);
            this.rewardAd = null;
            this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        this.rewardAd = null;
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return this.interstitialAd != null && this.interstitialState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && this.interstitialState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            InterstitialAd.load((Context)activity, (String)adId.adId, (AdRequest)this.buildRequest(), (InterstitialAdLoadCallback)this.interstitialLoadListener);
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.show(activity);
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        this.interstitialAd = null;
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && !TextUtils.isEmpty((CharSequence)this.bannerAd.getAdUnitId()) && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            if (this.bannerAd == null || !adId.adId.equals(this.bannerAd.getAdUnitId())) {
                this.bannerAd = new AdView((Context)activity);
                this.bannerAd.setAdListener(this.bannerListener);
                Yodo1MasAdBuildConfig adBuildConfig = Yodo1MasHelper.getInstance().getAdBuildConfig();
                if (adBuildConfig != null && adBuildConfig.isEnableAdaptiveBanner()) {
                    this.bannerAd.setAdSize(this.getAdSize());
                } else {
                    this.bannerAd.setAdSize(AdSize.BANNER);
                }
                this.bannerAd.setAdUnitId(adId.adId);
            }
            if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Log.d((String)this.TAG, (String)message);
                this.bannerAd.loadAd(this.buildRequest());
                this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            }
        }
    }

    private AdSize getAdSize() {
        Display display = this.currentActivity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;
        int adWidth = (int)(widthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)this.currentActivity, (int)adWidth);
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            Yodo1MasBanner.showBanner((Activity)activity, (View)this.bannerAd, (JSONObject)object);
        }
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null) {
            Yodo1MasBanner.removeBanner((View)this.bannerAd);
            if (destroy) {
                this.bannerAd.destroy();
                this.bannerAd = null;
                this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                this.loadBannerAdvert();
            }
        }
    }

    private AdRequest buildRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        Bundle extras = new Bundle();
        if (!Yodo1MasHelper.getInstance().isGDPRUserConsent()) {
            extras.putString("npa", "1");
        }
        if (Yodo1MasHelper.getInstance().isCCPADoNotSell()) {
            extras.putInt("rdp", 1);
        }
        return builder.addNetworkExtrasBundle(AdMobAdapter.class, extras).build();
    }
}

