/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobBannerAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobInterstitialAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobRewardAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdaptersPrivacy;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.Map;

public class Yodo1MasAdMobAdapter
extends Yodo1MasAdapterBase {
    public String getAdvertCode() {
        return "admob";
    }

    public String getSDKVersion() {
        return MobileAds.getVersionString();
    }

    public String getMediationVersion() {
        return "4.7.2";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (!this.isMax()) {
                MobileAds.disableMediationAdapterInitialization((Context)this.currentActivity);
            }
            this.preInitialize();
            MobileAds.initialize((Context)this.currentActivity, initializationStatus -> {
                Map statusMap = initializationStatus.getAdapterStatusMap();
                for (String adapterClass : statusMap.keySet()) {
                    AdapterStatus status = (AdapterStatus)statusMap.get(adapterClass);
                    Log.d((String)this.TAG, (String)String.format("Adapter name: %s, Description: %s, Latency: %d", adapterClass, status.getDescription(), status.getLatency()));
                }
                String message = "method: onInitializationComplete";
                Log.d((String)this.TAG, (String)message);
                this.updatePrivacy();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
            });
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isMax() {
        return false;
    }

    public boolean isInitSDK() {
        boolean init = super.isInitSDK();
        if (init) {
            String key = MobileAds.class.getName();
            AdapterStatus status = (AdapterStatus)MobileAds.getInitializationStatus().getAdapterStatusMap().get(key);
            init = status != null && status.getInitializationState() == AdapterStatus.State.READY;
        }
        return init;
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        SharedPreferences sharedPref = this.currentActivity.getPreferences(0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt("gad_npa", Yodo1MasHelper.getInstance().isGDPRUserConsent() ? 0 : 1);
        editor.putInt("gad_rdp", Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0);
        editor.apply();
        Yodo1MasAdaptersPrivacy.setAdColonyPrivacy();
        Yodo1MasAdaptersPrivacy.setAppLovinPrivacy((Context)this.currentActivity);
        Yodo1MasAdaptersPrivacy.setFacebookPrivacy();
        Yodo1MasAdaptersPrivacy.setFyberPrivacy();
        Yodo1MasAdaptersPrivacy.setInMobiPrivacy();
        Yodo1MasAdaptersPrivacy.setIronSourcePrivacy((Context)this.currentActivity);
        Yodo1MasAdaptersPrivacy.setMyTargetPrivacy();
        Yodo1MasAdaptersPrivacy.setTapjoyPrivacy();
        Yodo1MasAdaptersPrivacy.setUnityAdsPrivacy((Context)this.currentActivity);
        Yodo1MasAdaptersPrivacy.setVunglePrivacy();
    }

    private void preInitialize() {
        RequestConfiguration.Builder builder = MobileAds.getRequestConfiguration().toBuilder();
        int ageRestrictedUserTag = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted() ? 1 : 0;
        builder.setTagForChildDirectedTreatment(ageRestrictedUserTag);
        RequestConfiguration requestConfiguration = builder.build();
        MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
    }

    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAdMobRewardAdapter.class;
    }

    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAdMobInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAdMobBannerAdapter.class;
    }

    public Yodo1MasBannerAdapterBase getBannerAdapter() {
        Yodo1MasAdMobBannerAdapter bannerAdapter = (Yodo1MasAdMobBannerAdapter)super.getBannerAdapter();
        bannerAdapter.setMax(this.isMax());
        return bannerAdapter;
    }

    public static AdRequest buildRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        Bundle extras = new Bundle();
        if (!Yodo1MasHelper.getInstance().isGDPRUserConsent()) {
            extras.putString("npa", "1");
        }
        if (Yodo1MasHelper.getInstance().isCCPADoNotSell()) {
            extras.putInt("rdp", 1);
        }
        return builder.addNetworkExtrasBundle(AdMobAdapter.class, extras).build();
    }
}

