/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;

public class Yodo1MasAdMobRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;
    private boolean isRewarded;
    private final RewardedAdLoadCallback rewardLoadListener = new RewardedAdLoadCallback(){

        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            super.onAdLoaded((Object)rewardedAd);
            String message = "method: onAdLoaded, reward, Mediation Adapter Class Name: " + rewardedAd.getResponseInfo().getMediationAdapterClassName();
            Log.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            rewardedAd.setFullScreenContentCallback(Yodo1MasAdMobRewardAdapter.this.rewardShowListener);
            Yodo1MasAdMobRewardAdapter.this.rewardAd = rewardedAd;
            Yodo1MasAdMobRewardAdapter.this.callbackLoad();
        }

        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = "method: onAdFailedToLoad, reward error: " + adError.toString();
            Log.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }
    };
    private final FullScreenContentCallback rewardShowListener = new FullScreenContentCallback(){

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = "method: onAdShowedFullScreenContent, reward";
            Log.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardAdapter.this.callbackOpen();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = "method: onAdDismissedFullScreenContent, reward";
            Log.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            if (Yodo1MasAdMobRewardAdapter.this.isRewarded) {
                Yodo1MasAdMobRewardAdapter.this.callbackEarned();
                Yodo1MasAdMobRewardAdapter.this.isRewarded = false;
            }
            Yodo1MasAdMobRewardAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = "method: onAdFailedToShowFullScreenContent, reward, error: " + adError.toString();
            Log.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdClicked() {
            Yodo1MasAdMobRewardAdapter.this.callbackClick();
        }
    };
    private final OnUserEarnedRewardListener userEarnedRewardListener = new OnUserEarnedRewardListener(){

        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = "method: onUserEarnedReward, reward item: " + rewardItem.getType();
            Log.d((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardAdapter.this.isRewarded = true;
        }
    };

    public Yodo1MasAdMobRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && super.isRewardAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Log.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        RewardedAd.load((Context)activity, (String)adId, (AdRequest)Yodo1MasAdMobAdapter.buildRequest(), (RewardedAdLoadCallback)this.rewardLoadListener);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.show(activity, this.userEarnedRewardListener);
            this.callbackOpen();
        }
    }
}

