/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasAdMobBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private AdView bannerAd;
    private boolean isMax;
    private final AdListener bannerListener = new AdListener(){

        public void onAdOpened() {
            String message = "method: onAdOpened, banner";
            Log.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobBannerAdapter.this.callback(1001, Yodo1MasAdMobBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdClicked() {
            String message = "method: onAdClicked, banner";
            Log.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
        }

        public void onAdClosed() {
            String message = "method: onAdClosed, banner";
            Log.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAdMobBannerAdapter.this.callback(1002, Yodo1MasAdMobBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobBannerAdapter.this.loadBannerAdvert();
        }

        public void onAdLoaded() {
            super.onAdLoaded();
            String message = "method: onAdLoaded, banner, Mediation Adapter Class Name: " + (Yodo1MasAdMobBannerAdapter.this.bannerAd == null || Yodo1MasAdMobBannerAdapter.this.bannerAd.getResponseInfo() == null ? "" : Yodo1MasAdMobBannerAdapter.this.bannerAd.getResponseInfo().getMediationAdapterClassName());
            Log.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAdMobBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasAdMobBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasAdMobBannerAdapter.this.callback(1003, Yodo1MasAdMobBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobBannerAdapter.this.callbackAdapterState();
        }

        public void onAdFailedToLoad(LoadAdError adError) {
            String message = "method: onAdFailedToLoad, banner, error: " + adError.toString();
            Log.d((String)Yodo1MasAdMobBannerAdapter.this.TAG, (String)message);
            Yodo1MasAdMobBannerAdapter.this.trackAdRequestFailed(adError.getCode(), adError.getMessage());
            Yodo1MasAdMobBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasAdMobBannerAdapter.this.isMax()) {
                Yodo1MasAdMobBannerAdapter.this.handleLoadFailedCallback(message);
                Yodo1MasAdMobBannerAdapter.this.nextBanner();
                Yodo1MasAdMobBannerAdapter.this.loadBannerAdvertDelayed();
            } else if (Yodo1MasAdMobBannerAdapter.this.isLastPlacement()) {
                Yodo1MasAdMobBannerAdapter.this.handleLoadFailedCallback(message);
            } else {
                Yodo1MasAdMobBannerAdapter.this.nextBanner();
                Yodo1MasAdMobBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }
    };

    public Yodo1MasAdMobBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isMax() {
        return this.isMax;
    }

    public void setMax(boolean max) {
        this.isMax = max;
    }

    public boolean isBannerAdvertLoaded() {
        return this.bannerAd != null && !TextUtils.isEmpty((CharSequence)this.bannerAd.getAdUnitId()) && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!this.isMax() && adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            if (this.bannerAd == null || !adId.adId.equals(this.bannerAd.getAdUnitId())) {
                this.bannerAd = new AdView((Context)activity);
                this.bannerAd.setAdListener(this.bannerListener);
                this.setBannerSize(activity, this.bannerAd);
                this.bannerAd.setAdUnitId(adId.adId);
            }
            if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
                String message = "method: loadBannerAdvert, loading banner ad...";
                Log.d((String)this.TAG, (String)message);
                this.bannerAd.loadAd(this.buildRequest());
                this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
                this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
                this.logAdIdInfo(adId);
            }
        }
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return true;
    }

    private AdRequest buildRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        Bundle extras = new Bundle();
        if (!Yodo1MasHelper.getInstance().isGDPRUserConsent()) {
            extras.putString("npa", "1");
        }
        if (Yodo1MasHelper.getInstance().isCCPADoNotSell()) {
            extras.putInt("rdp", 1);
        }
        return builder.addNetworkExtrasBundle(AdMobAdapter.class, extras).build();
    }

    private void setBannerSize(Activity activity, AdView bannerAd) {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Log.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            bannerAd.setAdSize(AdSize.BANNER);
        } else if (Yodo1MasBannerAdSize.LargeBanner == size) {
            bannerAd.setAdSize(AdSize.LARGE_BANNER);
        } else if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            bannerAd.setAdSize(AdSize.MEDIUM_RECTANGLE);
        } else if (Yodo1MasBannerAdSize.SmartBanner == size) {
            bannerAd.setAdSize(AdSize.SMART_BANNER);
        } else if (Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            bannerAd.setAdSize(this.getAdSize(activity));
        }
    }

    private AdSize getAdSize(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;
        int adWidth = (int)(widthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)activity, (int)adWidth);
    }

    private void handleLoadFailedCallback(String message) {
        Yodo1MasError error = new Yodo1MasError(-600202, this.TAG + ":{" + message + "}");
        this.callback(error);
        this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
        this.callbackAdapterState();
    }
}

