package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;

public class Yodo1MasAdMobRewardAdapter extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;
    private boolean isRewarded;

    public Yodo1MasAdMobRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && super.isRewardAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Log.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        RewardedAd.load(activity, adId, Yodo1MasAdMobAdapter.buildRequest(), rewardLoadListener);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d(TAG, message);
            rewardAd.show(activity, userEarnedRewardListener);
            callbackOpen();
        }
    }

    private final RewardedAdLoadCallback rewardLoadListener = new RewardedAdLoadCallback() {
        @Override
        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            super.onAdLoaded(rewardedAd);
            rewardedAd.setFullScreenContentCallback(rewardShowListener);
            Yodo1MasAdMobRewardAdapter.this.rewardAd = rewardedAd;
            adSource = Yodo1MasAdMobUtils.getAdSource(rewardAd.getResponseInfo().getMediationAdapterClassName());
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Log.d(TAG, message);
            callbackLoad();
        }

        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "reward", adError);
            Log.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }
    };

    private final FullScreenContentCallback rewardShowListener = new FullScreenContentCallback() {
        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Log.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Log.d(TAG, message);
            if (isRewarded) {
                callbackEarned();
                isRewarded = false;
            }
            callbackClose();
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "reward", adError);
            Log.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }

        @Override
        public void onAdClicked() {
            callbackClick();
        }
    };

    private final OnUserEarnedRewardListener userEarnedRewardListener = new OnUserEarnedRewardListener() {
        @Override
        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = Yodo1MasAdMobUtils.getFormatString("onUserEarnedReward", "reward", rewardAd.getAdUnitId(), rewardAd.getResponseInfo().getMediationAdapterClassName());
            Log.d(TAG, message);
            isRewarded = true;
        }
    };
}
