package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasAdMobInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {
    private InterstitialAd interstitialAd;

    public Yodo1MasAdMobInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.v(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        InterstitialAd.load(activity, adId, Yodo1MasAdMobAdapter.buildRequest(), interstitialLoadListener);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.v(TAG, message);
            interstitialAd.show(activity);
        }
    }

    private final InterstitialAdLoadCallback interstitialLoadListener = new InterstitialAdLoadCallback() {
        @Override
        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            super.onAdLoaded(interstitialAd);
            interstitialAd.setFullScreenContentCallback(interstitialShowListener);
            Yodo1MasAdMobInterstitialAdapter.this.interstitialAd = interstitialAd;
            adSource = Yodo1MasAdMobUtils.getAdSource(interstitialAd.getResponseInfo().getMediationAdapterClassName());

            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "interstitial", interstitialAd.getAdUnitId(), interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "interstitial", adError);
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }
    };

    private final FullScreenContentCallback interstitialShowListener = new FullScreenContentCallback() {

        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "interstitial", interstitialAd.getAdUnitId(), interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "interstitial", interstitialAd.getAdUnitId(), interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "interstitial", adError);
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }

        @Override
        public void onAdClicked() {
            callbackClick();
        }
    };
}
