package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasAdMobAppOpenAdapter extends Yodo1MasAppOpenAdapterBase {

    private AppOpenAd appOpenAd;
    private final FullScreenContentCallback appOpenAdShowListener = new FullScreenContentCallback() {
        @Override
        public void onAdClicked() {
            callbackClick();
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "appOpenAd", appOpenAd.getAdUnitId(), appOpenAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "appOpenAd", adError);
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }

        @Override
        public void onAdImpression() {
            super.onAdImpression();
        }

        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "appOpenAd", appOpenAd.getAdUnitId(), appOpenAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v(TAG, message);
            callbackOpen();
        }
    };
    private final AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadListener = new AppOpenAd.AppOpenAdLoadCallback() {
        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "appOpenAd", loadAdError);
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, loadAdError.getCode(), loadAdError.getMessage());
        }

        @Override
        public void onAdLoaded(@NonNull AppOpenAd appOpenAd) {
            super.onAdLoaded(appOpenAd);
            appOpenAd.setFullScreenContentCallback(appOpenAdShowListener);
            Yodo1MasAdMobAppOpenAdapter.this.appOpenAd = appOpenAd;
            adSource = Yodo1MasAdMobUtils.getAdSource(appOpenAd.getResponseInfo().getMediationAdapterClassName());

            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "appOpenAd", appOpenAd.getAdUnitId(), appOpenAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }
    };

    public Yodo1MasAdMobAppOpenAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isAppOpenAdLoaded() {
        return appOpenAd != null && super.isAppOpenAdLoaded();
    }

    @Override
    public void loadAppOpenAdvert(Activity activity) {
        super.loadAppOpenAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (appOpenStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadAppOpenAdvert, loading AppOpen ad...";
        Yodo1MasLog.v(TAG, message);
        trackLoadTime();
        appOpenStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        AppOpenAd.load(activity, adId, Yodo1MasAdMobAdapter.buildRequest(), getOrientationParam(activity), appOpenAdLoadListener);
    }

    @Override
    public void showAppOpenAdvertFromActivity(Activity activity) {
        super.showAppOpenAdvertFromActivity(activity);
        if (isAppOpenAdLoaded()) {
            String message = "method: showAppOpenAdvert, show appOpen ad...";
            Yodo1MasLog.v(TAG, message);
            appOpenAd.show(activity);
        }
    }

    private int getOrientationParam(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        if (Configuration.ORIENTATION_PORTRAIT == orientation) {
            return AppOpenAd.APP_OPEN_AD_ORIENTATION_PORTRAIT;
        } else if (Configuration.ORIENTATION_LANDSCAPE == orientation) {
            return AppOpenAd.APP_OPEN_AD_ORIENTATION_LANDSCAPE;
        } else {
            return AppOpenAd.APP_OPEN_AD_ORIENTATION_LANDSCAPE;
        }

    }
}
