/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.gam;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import com.yodo1.mas.mediation.gam.Yodo1MasGoogleAdManagerAdapter;
import java.util.List;

public class Yodo1MasGoogleAdManagerAppOpenAdapter
extends Yodo1MasAppOpenAdapterBase {
    private AppOpenAd appOpenAd;
    private final FullScreenContentCallback appOpenAdShowListener = new FullScreenContentCallback(){

        public void onAdClicked() {
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.callbackClick();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "appOpenAd", Yodo1MasGoogleAdManagerAppOpenAdapter.this.appOpenAd.getAdUnitId(), Yodo1MasGoogleAdManagerAppOpenAdapter.this.appOpenAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d((String)Yodo1MasGoogleAdManagerAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "appOpenAd", adError);
            Yodo1MasLog.d((String)Yodo1MasGoogleAdManagerAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasGoogleAdManagerAppOpenAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdImpression() {
            super.onAdImpression();
        }

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "appOpenAd", Yodo1MasGoogleAdManagerAppOpenAdapter.this.appOpenAd.getAdUnitId(), Yodo1MasGoogleAdManagerAppOpenAdapter.this.appOpenAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d((String)Yodo1MasGoogleAdManagerAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.callbackOpen();
        }
    };
    private final AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadListener = new AppOpenAd.AppOpenAdLoadCallback(){

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "appOpenAd", (AdError)loadAdError);
            Yodo1MasLog.d((String)Yodo1MasGoogleAdManagerAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasGoogleAdManagerAppOpenAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.callbackError(error, loadAdError.getCode(), loadAdError.getMessage());
        }

        public void onAdLoaded(@NonNull AppOpenAd appOpenAd) {
            super.onAdLoaded((Object)appOpenAd);
            appOpenAd.setFullScreenContentCallback(Yodo1MasGoogleAdManagerAppOpenAdapter.this.appOpenAdShowListener);
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.appOpenAd = appOpenAd;
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSource(appOpenAd.getResponseInfo().getMediationAdapterClassName());
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "appOpenAd", appOpenAd.getAdUnitId(), appOpenAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d((String)Yodo1MasGoogleAdManagerAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasGoogleAdManagerAppOpenAdapter.this.callbackLoad();
        }
    };

    public Yodo1MasGoogleAdManagerAppOpenAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isAppOpenAdLoaded() {
        return this.appOpenAd != null && super.isAppOpenAdLoaded();
    }

    public void loadAppOpenAdvert(Activity activity) {
        super.loadAppOpenAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.appOpenStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadAppOpenAdvert, loading AppOpen ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.trackLoadTime();
        this.appOpenStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        AppOpenAd.load((Context)activity, (String)adId, (AdManagerAdRequest)Yodo1MasGoogleAdManagerAdapter.buildRequest(), (int)this.getOrientationParam((Context)activity), (AppOpenAd.AppOpenAdLoadCallback)this.appOpenAdLoadListener);
    }

    public void showAppOpenAdvertFromActivity(Activity activity) {
        super.showAppOpenAdvertFromActivity(activity);
        if (this.isAppOpenAdLoaded()) {
            String message = "method: showAppOpenAdvert, show appOpen ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.appOpenAd.show(activity);
        }
    }

    private int getOrientationParam(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        if (1 == orientation) {
            return 1;
        }
        if (2 == orientation) {
            return 2;
        }
        return 2;
    }
}

