/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import java.util.List;

public class Yodo1MasAdMobInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private InterstitialAd interstitialAd;
    private final FullScreenContentCallback interstitialShowListener = new FullScreenContentCallback(){

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "interstitial", Yodo1MasAdMobInterstitialAdapter.this.interstitialAd.getAdUnitId(), Yodo1MasAdMobInterstitialAdapter.this.interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.callbackOpen();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "interstitial", Yodo1MasAdMobInterstitialAdapter.this.interstitialAd.getAdUnitId(), Yodo1MasAdMobInterstitialAdapter.this.interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "interstitial", adError);
            Yodo1MasLog.v((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdClicked() {
            Yodo1MasAdMobInterstitialAdapter.this.callbackClick();
        }
    };
    private final InterstitialAdLoadCallback interstitialLoadListener = new InterstitialAdLoadCallback(){

        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            super.onAdLoaded((Object)interstitialAd);
            interstitialAd.setFullScreenContentCallback(Yodo1MasAdMobInterstitialAdapter.this.interstitialShowListener);
            Yodo1MasAdMobInterstitialAdapter.this.interstitialAd = interstitialAd;
            Yodo1MasAdMobInterstitialAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSource(interstitialAd.getResponseInfo().getMediationAdapterClassName());
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "interstitial", interstitialAd.getAdUnitId(), interstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobInterstitialAdapter.this.callbackLoad();
        }

        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "interstitial", (AdError)adError);
            Yodo1MasLog.v((String)Yodo1MasAdMobInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }
    };

    public Yodo1MasAdMobInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && super.isInterstitialAdLoaded();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.v((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        InterstitialAd.load((Context)activity, (String)adId, (AdRequest)Yodo1MasAdMobAdapter.buildRequest(), (InterstitialAdLoadCallback)this.interstitialLoadListener);
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.v((String)this.TAG, (String)message);
            this.interstitialAd.show(activity);
        }
    }
}

