/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;

public class Yodo1MasAdMobRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;
    private boolean isRewarded;
    private final FullScreenContentCallback rewardShowListener = new FullScreenContentCallback(){

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardAdapter.this.callbackOpen();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            if (Yodo1MasAdMobRewardAdapter.this.isRewarded) {
                Yodo1MasAdMobRewardAdapter.this.callbackEarned();
                Yodo1MasAdMobRewardAdapter.this.isRewarded = false;
            }
            Yodo1MasAdMobRewardAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "reward", adError);
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdClicked() {
            Yodo1MasAdMobRewardAdapter.this.callbackClick();
        }
    };
    private final RewardedAdLoadCallback rewardLoadListener = new RewardedAdLoadCallback(){

        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            super.onAdLoaded((Object)rewardedAd);
            rewardedAd.setFullScreenContentCallback(Yodo1MasAdMobRewardAdapter.this.rewardShowListener);
            Yodo1MasAdMobRewardAdapter.this.rewardAd = rewardedAd;
            Yodo1MasAdMobRewardAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSource(Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardAdapter.this.callbackLoad();
        }

        public void onAdFailedToLoad(@NonNull LoadAdError adError) {
            super.onAdFailedToLoad(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "reward", (AdError)adError);
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }
    };
    private final OnUserEarnedRewardListener userEarnedRewardListener = new OnUserEarnedRewardListener(){

        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = Yodo1MasAdMobUtils.getFormatString("onUserEarnedReward", "reward", Yodo1MasAdMobRewardAdapter.this.rewardAd.getAdUnitId(), Yodo1MasAdMobRewardAdapter.this.rewardAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardAdapter.this.isRewarded = true;
        }
    };

    public Yodo1MasAdMobRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && super.isRewardAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        RewardedAd.load((Context)activity, (String)adId, (AdRequest)Yodo1MasAdMobAdapter.buildRequest(), (RewardedAdLoadCallback)this.rewardLoadListener);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v((String)this.TAG, (String)message);
            this.rewardAd.show(activity, this.userEarnedRewardListener);
            this.callbackOpen();
        }
    }
}

