/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobAdapter;
import com.yodo1.mas.mediation.admob.Yodo1MasAdMobUtils;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import java.util.List;

public class Yodo1MasAdMobRewardedInterstitialAdapter
extends Yodo1MasRewardedInterstitialAdapterBase {
    private RewardedInterstitialAd rewardedInterstitialAd;
    private boolean isRewarded;
    private final FullScreenContentCallback rewardedInterstitialShowListener = new FullScreenContentCallback(){

        public void onAdClicked() {
            Yodo1MasAdMobRewardedInterstitialAdapter.this.callbackClick();
        }

        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "rewardedInterstitial", Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd.getAdUnitId(), Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG, (String)message);
            if (Yodo1MasAdMobRewardedInterstitialAdapter.this.isRewarded) {
                Yodo1MasAdMobRewardedInterstitialAdapter.this.callbackEarned();
                Yodo1MasAdMobRewardedInterstitialAdapter.this.isRewarded = false;
            }
            Yodo1MasAdMobRewardedInterstitialAdapter.this.callbackClose();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "rewardedInterstitial", adError);
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobRewardedInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdImpression() {
            super.onAdImpression();
        }

        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "rewardedInterstitial", Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd.getAdUnitId(), Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardedInterstitialAdapter.this.callbackOpen();
        }
    };
    private final RewardedInterstitialAdLoadCallback rewardedInterstitialLoadListener = new RewardedInterstitialAdLoadCallback(){

        public void onAdLoaded(@NonNull RewardedInterstitialAd rewardedInterstitialAd) {
            super.onAdLoaded((Object)rewardedInterstitialAd);
            rewardedInterstitialAd.setFullScreenContentCallback(Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialShowListener);
            Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd = rewardedInterstitialAd;
            Yodo1MasAdMobRewardedInterstitialAdapter.this.adSource = Yodo1MasAdMobUtils.getAdSource(rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "rewardedInterstitial", rewardedInterstitialAd.getAdUnitId(), rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardedInterstitialAdapter.this.callbackLoad();
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "rewardedInterstitial", (AdError)loadAdError);
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdMobRewardedInterstitialAdapter.this.callbackError(error, loadAdError.getCode(), loadAdError.getMessage());
        }
    };
    private final OnUserEarnedRewardListener userEarnedRewardedInterstitialListener = new OnUserEarnedRewardListener(){

        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = Yodo1MasAdMobUtils.getFormatString("onUserEarnedReward", "rewardedInterstitial", Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd.getAdUnitId(), Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.v((String)Yodo1MasAdMobRewardedInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAdMobRewardedInterstitialAdapter.this.isRewarded = true;
        }
    };

    public Yodo1MasAdMobRewardedInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardedInterstitialAdLoaded() {
        return this.rewardedInterstitialAd != null && super.isRewardedInterstitialAdLoaded();
    }

    public void loadRewardedInterstitialAdvert(Activity activity) {
        super.loadRewardedInterstitialAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardedInterstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardedInterstitialAdvert, loading RewardedInterstitial ad...";
        Yodo1MasLog.v((String)this.TAG, (String)message);
        this.rewardedInterstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        RewardedInterstitialAd.load((Context)activity, (String)adId, (AdRequest)Yodo1MasAdMobAdapter.buildRequest(), (RewardedInterstitialAdLoadCallback)this.rewardedInterstitialLoadListener);
    }

    public void showRewardedInterstitialAdvertFromActivity(Activity activity) {
        super.showRewardedInterstitialAdvertFromActivity(activity);
        if (this.isRewardedInterstitialAdLoaded()) {
            String message = "method: showRewardedInterstitialAdvert, show rewardedinterstitial ad...";
            Yodo1MasLog.v((String)this.TAG, (String)message);
            this.rewardedInterstitialAd.show(activity, this.userEarnedRewardedInterstitialListener);
        }
    }
}

