package com.yodo1.mas.mediation.admob;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

import java.util.List;

public class Yodo1MasAdMobRewardedInterstitialAdapter extends Yodo1MasRewardedInterstitialAdapterBase {
    private RewardedInterstitialAd rewardedInterstitialAd;
    private boolean isRewarded;
    private final FullScreenContentCallback rewardedInterstitialShowListener = new FullScreenContentCallback() {
        @Override
        public void onAdClicked() {
            callbackClick();
        }

        @Override
        public void onAdDismissedFullScreenContent() {
            super.onAdDismissedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdDismissedFullScreenContent", "rewardedInterstitial", rewardedInterstitialAd.getAdUnitId(), rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            if (isRewarded) {
                callbackEarned();
                isRewarded = false;
            }
            callbackClose();
        }

        @Override
        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            super.onAdFailedToShowFullScreenContent(adError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToShowFullScreenContent", "rewardedInterstitial", adError);
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }

        @Override
        public void onAdImpression() {
            super.onAdImpression();
        }

        @Override
        public void onAdShowedFullScreenContent() {
            super.onAdShowedFullScreenContent();
            String message = Yodo1MasAdMobUtils.getFormatString("onAdShowedFullScreenContent", "rewardedInterstitial", rewardedInterstitialAd.getAdUnitId(), rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }
    };
    private final RewardedInterstitialAdLoadCallback rewardedInterstitialLoadListener = new RewardedInterstitialAdLoadCallback() {

        @Override
        public void onAdLoaded(@NonNull RewardedInterstitialAd rewardedInterstitialAd) {
            super.onAdLoaded(rewardedInterstitialAd);
            rewardedInterstitialAd.setFullScreenContentCallback(rewardedInterstitialShowListener);
            Yodo1MasAdMobRewardedInterstitialAdapter.this.rewardedInterstitialAd = rewardedInterstitialAd;
            adSource = Yodo1MasAdMobUtils.getAdSource(rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());

            String message = Yodo1MasAdMobUtils.getFormatString("onAdLoaded", "rewardedInterstitial", rewardedInterstitialAd.getAdUnitId(), rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            callbackLoad();
        }

        @Override
        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            String message = Yodo1MasAdMobUtils.getAdErrorFormatString("onAdFailedToLoad", "rewardedInterstitial", loadAdError);
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, loadAdError.getCode(), loadAdError.getMessage());
        }
    };
    private final OnUserEarnedRewardListener userEarnedRewardedInterstitialListener = new OnUserEarnedRewardListener() {
        @Override
        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            String message = Yodo1MasAdMobUtils.getFormatString("onUserEarnedReward", "rewardedInterstitial", rewardedInterstitialAd.getAdUnitId(), rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
            Yodo1MasLog.d(TAG, message);
            isRewarded = true;
        }
    };

    public Yodo1MasAdMobRewardedInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardedInterstitialAdLoaded() {
        return rewardedInterstitialAd != null && super.isRewardedInterstitialAdLoaded();
    }

    @Override
    public void loadRewardedInterstitialAdvert(Activity activity) {
        super.loadRewardedInterstitialAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (rewardedInterstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardedInterstitialAdvert, loading RewardedInterstitial ad...";
        Yodo1MasLog.d(TAG, message);
        rewardedInterstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        RewardedInterstitialAd.load(activity, adId, Yodo1MasAdMobAdapter.buildRequest(), rewardedInterstitialLoadListener);
    }

    @Override
    public void showRewardedInterstitialAdvertFromActivity(Activity activity) {
        super.showRewardedInterstitialAdvertFromActivity(activity);
        if (isRewardedInterstitialAdLoaded()) {
            String message = "method: showRewardedInterstitialAdvert, show rewardedinterstitial ad...";
            Yodo1MasLog.d(TAG, message);

            rewardedInterstitialAd.show(activity, userEarnedRewardedInterstitialListener);
        }
    }
}
