/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;
import java.util.Map;

public class Yodo1MasAppLovinRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private final AppLovinAdLoadListener rewardLoadListener = new AppLovinAdLoadListener(){

        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasAppLovinRewardAdapter.this.advertCode, (String)Yodo1MasAppLovinRewardAdapter.this.getAdUnitId(), (boolean)true, (long)Yodo1MasAppLovinRewardAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasAppLovinRewardAdapter.this.callbackLoad(adRequestResult);
        }

        public void failedToReceiveAd(int code) {
            String message = "method: failedToReceiveAd, error: " + code;
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasAppLovinRewardAdapter.this.advertCode, (String)Yodo1MasAppLovinRewardAdapter.this.getAdUnitId(), (boolean)false, (long)Yodo1MasAppLovinRewardAdapter.this.getAdLoadDuration(), (String)(code + ""), (String)message);
            Yodo1MasAppLovinRewardAdapter.this.callbackError(error, code, message, adRequestResult);
        }
    };
    private final AppLovinAdVideoPlaybackListener rewardPlayListener = new AppLovinAdVideoPlaybackListener(){

        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            String message = "method: videoPlaybackBegan, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
        }

        public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
            String message = "method: videoPlaybackEnded, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinRewardAdapter.this.callbackEarned();
        }
    };
    private final AppLovinAdDisplayListener rewardDisplayListener = new AppLovinAdDisplayListener(){

        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinRewardAdapter.this.callbackOpen();
        }

        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinRewardAdapter.this.callbackClose();
        }
    };
    private final AppLovinAdClickListener rewardClickListener = appLovinAd -> {
        String message = "method: adClicked, reward: " + appLovinAd.getAdIdNumber();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.callbackClick();
    };
    private final AppLovinAdRewardListener rewardedListener = new AppLovinAdRewardListener(){

        public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userRewardVerified, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
        }

        public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userOverQuota, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
        }

        public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userRewardRejected, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
        }

        public void validationRequestFailed(AppLovinAd appLovinAd, int i) {
            String message = "method: validationRequestFailed, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d((String)Yodo1MasAppLovinRewardAdapter.this.TAG, (String)message);
        }
    };
    private AppLovinIncentivizedInterstitial rewardAd;

    public Yodo1MasAppLovinRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && this.rewardAd.isAdReadyToDisplay();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        this.rewardAd = AppLovinIncentivizedInterstitial.create((Context)activity);
        this.rewardAd.preload(this.rewardLoadListener);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.rewardAd.show((Context)activity, this.rewardedListener, this.rewardPlayListener, this.rewardDisplayListener, this.rewardClickListener);
        }
    }
}

