package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdListener;
import com.applovin.mediation.nativeAds.MaxNativeAdLoader;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;

import java.util.List;

public class Yodo1MasAppLovinMaxNativeAdapter extends Yodo1MasNativeAdapterBase {

    private MaxAdRevenueListener revenueListener;
    private MaxNativeAdLoader loader;
    private MaxNativeAdView adView;
    private MaxAd ad;
    private final MaxNativeAdListener listener = new MaxNativeAdListener() {

        private void setViewBackground(ViewGroup group) {
            if (group == null || group.getChildCount() == 0) return;
            for (int i = 0; i < group.getChildCount(); i++) {
                View childView = group.getChildAt(i);
                if (!(childView instanceof TextView) && !(childView instanceof ImageView)) {
                    childView.setBackgroundColor(Color.TRANSPARENT);
                }
                if (childView instanceof ViewGroup) {
                    setViewBackground((ViewGroup) childView);
                }
            }
        }

        @Override
        public void onNativeAdLoaded(MaxNativeAdView maxNativeAdView, MaxAd maxAd) {
            String message = "method: onNativeAdLoaded, AdUnitId: " + maxAd.getAdUnitId() + ", NetworkName: " + maxAd.getNetworkName() + ", maxNativeAdView: " + maxNativeAdView;
            Yodo1MasLog.d(TAG, message);
            setViewBackground(maxNativeAdView);
            adView = maxNativeAdView;
            ad = maxAd;
            adSource = ad.getNetworkName();
            callbackLoad();
        }

        @Override
        public void onNativeAdLoadFailed(String adUnitId, MaxError maxError) {
            String message = "method: onNativeAdLoadFailed, AdUnitId: " + adUnitId + ", error: " + maxError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, adUnitId);
            callbackError(error, maxError.getCode() + "", maxError.getMessage());
        }

        @Override
        public void onNativeAdClicked(MaxAd maxAd) {
            String message = "method: onNativeAdClicked, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }
    };
    private Activity activity;

    public Yodo1MasAppLovinMaxNativeAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public View getNativeAdView() {
        return adView;
    }

    private void loadNativeAd(Activity activity, MaxNativeAdViewBinder.Builder builder) {

        if (activity == null) return;

        String unitId = this.getAdUniId(false);
        if (TextUtils.isEmpty(unitId)) return;

        MaxNativeAdView maxAdView = null;
        if (this.builder != null && builder != null) {
            MaxNativeAdViewBinder binder = builder.setTitleTextViewId(this.builder.getTitleTextViewId())
                    .setBodyTextViewId(this.builder.getBodyTextViewId())
                    .setAdvertiserTextViewId(this.builder.getAdvertiserTextViewId())
                    .setIconImageViewId(this.builder.getIconImageViewId())
                    .setMediaContentViewGroupId(this.builder.getMediaContentViewGroupId())
                    .setOptionsContentViewGroupId(this.builder.getOptionsContentViewGroupId())
                    .setCallToActionButtonId(this.builder.getCallToActionButtonId())
                    .build();
            maxAdView = new MaxNativeAdView(binder, activity);
        }

        this.nativeState = Yodo1MasAdapterBase.AdvertState.LOADING;
        this.activity = activity;
        loader = new MaxNativeAdLoader(unitId, activity);
        loader.setNativeAdListener(listener);
        if (this.revenueListener != null) {
            loader.setRevenueListener(revenueListener);
        }
        loader.setPlacement(nativePlacement);
        if (maxAdView != null) {
            loader.loadAd(maxAdView);
        } else {
            loader.loadAd();
        }
    }

    @Override
    public void loadNativeAd(Activity activity) {
        super.loadNativeAd(activity);
        loadNativeAd(activity, (MaxNativeAdViewBinder.Builder) null);
    }

    @Override
    public void loadNativeAd(Activity activity, int layoutId) {
        super.loadNativeAd(activity, layoutId);
        MaxNativeAdViewBinder.Builder builder = new MaxNativeAdViewBinder.Builder(layoutId);
        loadNativeAd(activity, builder);
    }

    @Override
    public void loadNativeAd(Activity activity, Class<? extends View> layoutView) {
        super.loadNativeAd(activity, layoutView);
        MaxNativeAdViewBinder.Builder builder = new MaxNativeAdViewBinder.Builder(generateView(layoutView, activity));
        loadNativeAd(activity, builder);
    }

    @Override
    public void loadNextNativeAd() {
        super.loadNextNativeAd();
        if (activity == null) return;
        String unitId = this.getAdUniId(true);
        if (loader.getAdUnitId().equals(unitId)) {
            return;
        }

        this.nativeState = Yodo1MasAdapterBase.AdvertState.LOADING;
        loader = new MaxNativeAdLoader(unitId, activity);
        loader.setNativeAdListener(listener);
        if (this.revenueListener != null) {
            loader.setRevenueListener(revenueListener);
        }
        loader.setPlacement(nativePlacement);
        loader.loadAd();
    }

    @Override
    public void destroyNative() {
        super.destroyNative();
        if (loader != null && ad != null) {
            loader.destroy(ad);
        }
        loader = null;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }
}
