package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasAppLovinBannerAdapter extends Yodo1MasBannerAdapterBase {

    // Banner
    private final AppLovinAdLoadListener bannerLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, banner: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequestSuccessed();
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");
            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void failedToReceiveAd(int i) {
            String message = "method: failedToReceiveAd, error: " + i;
            Yodo1MasLog.d(TAG, message);

            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            trackAdRequestFailed(i, null);

            if (isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                callback(error);
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            } else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }
    };
    private final AppLovinAdViewEventListener bannerPlayListener = new AppLovinAdViewEventListener() {
        @Override
        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adOpenedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adClosedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adLeftApplication, banner: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            String message = "method: adFailedToDisplay, banner: " + appLovinAd.getAdIdNumber() + ", error:" + appLovinAdViewDisplayErrorCode;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackDisplayError(error, appLovinAdViewDisplayErrorCode.toString(), null);

            if (isLastPlacement()) {
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            }
        }
    };
    private final AppLovinAdDisplayListener bannerDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, banner: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, banner: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_CLOSED, TAG + ":{" + message + "}");

            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            loadBannerAdvert();
        }
    };
    private final AppLovinAdClickListener bannerClickListener = appLovinAd -> {
        String message = "method: adClicked, banner: " + appLovinAd.getAdIdNumber();
        Yodo1MasLog.d(TAG, message);
    };
    private AppLovinAdView bannerAd;
    private String currBannerUnitId;

    public Yodo1MasAppLovinBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        return bannerAd != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter != null && !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (adId != null && !TextUtils.isEmpty(adId.adId) && (TextUtils.isEmpty(currBannerUnitId) || !adId.adId.equals(currBannerUnitId))) {
            AppLovinAdSize bannerSize = getBannerSize();
            bannerAd = new AppLovinAdView(bannerSize, adId.adId, activity);
            bannerAd.setAdLoadListener(bannerLoadListener);
            bannerAd.setAdDisplayListener(bannerDisplayListener);
            bannerAd.setAdViewEventListener(bannerPlayListener);
            bannerAd.setAdClickListener(bannerClickListener);
            currBannerUnitId = adId.adId;
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, load banner ad...";
            Yodo1MasLog.d(TAG, message);
            bannerAd.loadNextAd();
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }
    }

    private AppLovinAdSize getBannerSize() {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Yodo1MasLog.d(TAG, "setBannerSize: size: " + size.name());

        if (Yodo1MasBannerAdSize.Banner == size) {
            return AppLovinAdSize.BANNER;
        } else if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            return AppLovinAdSize.MREC;
        }
        return AppLovinAdSize.BANNER;
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                currBannerUnitId = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return true;
    }
}
