/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxUtil;
import com.yodo1.mas.mediation.applovin.Yodo1MasMaxAdRecordListener;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasSystemUtil;

public class Yodo1MasAppLovinMaxRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private double price;
    private final MaxRewardedAdListener rewardListener = new MaxRewardedAdListener(){

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxRewardAdapter.this.price = ad.getRevenue();
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Reward, Yodo1MasAppLovinMaxRewardAdapter.this.advertCode, ad.getAdUnitId(), true, Yodo1MasAppLovinMaxRewardAdapter.this.getAdLoadDuration(), ad.getWaterfall(), null, null);
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackLoad(adRequestResult);
        }

        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, reward, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinMaxRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Reward, Yodo1MasAppLovinMaxRewardAdapter.this.advertCode, adUnitId, false, Yodo1MasAppLovinMaxRewardAdapter.this.getAdLoadDuration(), adError.getWaterfall(), adError.getCode() + "", adError.getMessage());
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), adRequestResult);
        }

        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackOpen();
            if (Yodo1MasAppLovinMaxRewardAdapter.this.adRecordListener != null) {
                Yodo1MasAppLovinMaxRewardAdapter.this.adRecordListener.onAdDisplayed(Yodo1Mas.AdType.Reward, ad);
            }
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, reward, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinMaxRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackClose();
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackClick();
        }

        public void onRewardedVideoStarted(MaxAd ad) {
            String message = "method: onRewardedVideoStarted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
        }

        public void onRewardedVideoCompleted(MaxAd ad) {
            String message = "method: onRewardedVideoCompleted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
        }

        public void onUserRewarded(MaxAd ad, MaxReward reward) {
            String message = "method: onUserRewarded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackEarned();
        }
    };
    private MaxRewardedAd rewardAd;
    private MaxAdRevenueListener revenueListener;
    private Yodo1MasMaxAdRecordListener adRecordListener;
    private boolean isFirstLoad = true;

    public Yodo1MasAppLovinMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && this.rewardAd.isReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        Yodo1MasAdapterBase.AdId adIdObj = this.getAdId();
        if (adIdObj == null || TextUtils.isEmpty((CharSequence)adIdObj.adId)) {
            return;
        }
        String adId = adIdObj.adId;
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.rewardAd = MaxRewardedAd.getInstance((String)adId, (Activity)activity);
        this.rewardAd.setListener(this.rewardListener);
        if (this.revenueListener != null) {
            this.rewardAd.setRevenueListener(this.revenueListener);
        }
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        String amazonUnitId = Yodo1MasAppLovinMaxUtil.getAmazonUnitId(adIdObj);
        if (this.isFirstLoad && !TextUtils.isEmpty((CharSequence)amazonUnitId) && AdRegistration.isInitialized()) {
            this.isFirstLoad = false;
            this.loadAmazonAdfirst(activity, amazonUnitId, this.rewardAd);
        } else {
            this.rewardAd.loadAd();
        }
    }

    private void loadAmazonAdfirst(Activity activity, String amazonUnitId, final MaxRewardedAd rewardAd) {
        DTBAdRequest adLoader = new DTBAdRequest();
        DTBAdSize.DTBVideo dtbAdSize = new DTBAdSize.DTBVideo(320, 480, amazonUnitId);
        int orientation = Yodo1MasSystemUtil.getCurOrientation((Context)activity);
        if (2 == orientation) {
            dtbAdSize = new DTBAdSize.DTBVideo(480, 320, amazonUnitId);
        }
        adLoader.setSizes(new DTBAdSize[]{dtbAdSize});
        adLoader.loadAd(new DTBAdCallback(){

            public void onSuccess(@NonNull DTBAdResponse dtbAdResponse) {
                rewardAd.setLocalExtraParameter("amazon_ad_response", (Object)dtbAdResponse);
                rewardAd.loadAd();
            }

            public void onFailure(@NonNull AdError adError) {
                rewardAd.setLocalExtraParameter("amazon_ad_error", (Object)adError);
                rewardAd.loadAd();
            }
        });
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.rewardPlacement)) {
                this.rewardAd.showAd(this.rewardPlacement);
            } else {
                this.rewardAd.showAd();
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }

    public double getPrice() {
        return this.price * 1000.0;
    }
}

