package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.res.Configuration;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasSystemUtil;

import java.util.List;

public class Yodo1MasAppLovinMaxRewardAdapter extends Yodo1MasRewardAdapterBase {

    private double price;
    private final MaxRewardedAdListener rewardListener = new MaxRewardedAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            price = ad.getRevenue();
            Yodo1MasAdRequestResultInfo adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Reward, advertCode,
                            ad.getAdUnitId(), true, getAdLoadDuration(), ad.getWaterfall(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, reward, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Reward, advertCode,
                            adUnitId, false, getAdLoadDuration(), adError.getWaterfall(), adError.getCode() + "", adError.getMessage());
            callbackError(error, adError.getCode(), adError.getMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackOpen();
            if (adRecordListener != null) {
                adRecordListener.onAdDisplayed(Yodo1Mas.AdType.Reward, ad);
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, reward, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        @Override
        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClose();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }

        @Override
        public void onRewardedVideoStarted(MaxAd ad) {
            String message = "method: onRewardedVideoStarted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd ad) {
            String message = "method: onRewardedVideoCompleted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onUserRewarded(MaxAd ad, MaxReward reward) {
            String message = "method: onUserRewarded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackEarned();
        }
    };
    private MaxRewardedAd rewardAd;
    private MaxAdRevenueListener revenueListener;
    private Yodo1MasMaxAdRecordListener adRecordListener;
    private boolean isFirstLoad = true;

    public Yodo1MasAppLovinMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        Yodo1MasAdapterBase.AdId adIdObj = getAdId();
        if (adIdObj == null || TextUtils.isEmpty(adIdObj.adId)) return;

        String adId = adIdObj.adId;
        if (TextUtils.isEmpty(adId)) return;
        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        rewardAd = MaxRewardedAd.getInstance(adId, activity);
        rewardAd.setListener(rewardListener);
        if (this.revenueListener != null) {
            rewardAd.setRevenueListener(revenueListener);
        }

        adLoadStartTimeStamp = System.currentTimeMillis();
        String amazonUnitId = Yodo1MasAppLovinMaxUtil.getAmazonUnitId(adIdObj);
        if (isFirstLoad && !TextUtils.isEmpty(amazonUnitId) && AdRegistration.isInitialized()) {
            isFirstLoad = false;
            loadAmazonAdfirst(activity, amazonUnitId, rewardAd);
        } else {
            rewardAd.loadAd();
        }
    }

    private void loadAmazonAdfirst(Activity activity, String amazonUnitId, MaxRewardedAd rewardAd) {
        DTBAdRequest adLoader = new DTBAdRequest();
        DTBAdSize dtbAdSize = new DTBAdSize.DTBVideo(320, 480, amazonUnitId);

        int orientation = Yodo1MasSystemUtil.getCurOrientation(activity);
        if (Configuration.ORIENTATION_LANDSCAPE == orientation) {
            dtbAdSize = new DTBAdSize.DTBVideo(480, 320, amazonUnitId);
        }

        adLoader.setSizes(dtbAdSize);
        adLoader.loadAd(new DTBAdCallback() {
            @Override
            public void onSuccess(@NonNull final DTBAdResponse dtbAdResponse) {
                rewardAd.setLocalExtraParameter("amazon_ad_response", dtbAdResponse);
                rewardAd.loadAd();
            }

            @Override
            public void onFailure(@NonNull final AdError adError) {
                rewardAd.setLocalExtraParameter("amazon_ad_error", adError);
                rewardAd.loadAd();
            }
        });
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);

            if (!TextUtils.isEmpty(rewardPlacement)) {
                rewardAd.showAd(rewardPlacement);
            } else {
                rewardAd.showAd();
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd.destroy();
        }
        rewardAd = null;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }

    @Override
    public double getPrice() {
        return price * 1000;
    }
}
