/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.sdk.AppLovinSdkUtils;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxUtil;
import java.util.List;

public class Yodo1MasAppLovinMaxBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final MaxAdViewAdListener bannerListener = new MaxAdViewAdListener(){

        public void onAdExpanded(MaxAd ad) {
            String message = "method: onAdExpanded, banner, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxBannerAdapter.this.callback(1001, Yodo1MasAppLovinMaxBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdCollapsed(MaxAd ad) {
            String message = "method: onAdCollapsed, banner, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxBannerAdapter.this.callback(1002, Yodo1MasAppLovinMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAppLovinMaxBannerAdapter.this.loadBannerAdvert();
        }

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, banner, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAppLovinMaxBannerAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxBannerAdapter.this.price = ad.getRevenue();
            Yodo1MasAppLovinMaxBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasAppLovinMaxBannerAdapter.this.callback(1003, Yodo1MasAppLovinMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasAppLovinMaxBannerAdapter.this.callbackAdapterState();
        }

        public void onAdLoadFailed(String adUnitId, MaxError maxError) {
            String message = "method: onAdLoadFailed, banner, AdUnitId: " + adUnitId + ", error: " + maxError.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxBannerAdapter.this.adSource = "";
            Yodo1MasAppLovinMaxBannerAdapter.this.trackAdRequestFailed(maxError.getCode(), maxError.getMessage());
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxBannerAdapter.this.callback(error);
            Yodo1MasAppLovinMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAppLovinMaxBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
            Yodo1MasAppLovinMaxBannerAdapter.this.callbackAdapterState();
            Yodo1MasAppLovinMaxBannerAdapter.this.nextBanner();
            Yodo1MasAppLovinMaxBannerAdapter.this.loadBannerAdvertDelayed();
        }

        public void onAdDisplayed(MaxAd ad) {
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError maxError) {
            String message = "method: onAdDisplayFailed, banner, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName() + ", error: " + maxError.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxBannerAdapter.this.callbackDisplayError(error, maxError.getCode(), maxError.getMessage());
            Yodo1MasAppLovinMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAppLovinMaxBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
            Yodo1MasAppLovinMaxBannerAdapter.this.callbackAdapterState();
            Yodo1MasAppLovinMaxBannerAdapter.this.nextBanner();
            Yodo1MasAppLovinMaxBannerAdapter.this.loadBannerAdvert();
        }

        public void onAdHidden(MaxAd ad) {
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, banner, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxBannerAdapter.this.TAG, (String)message);
        }
    };
    private MaxAdView bannerAd;
    private String currBannerUnitId;
    private MaxAdRevenueListener revenueListener;
    private double price;

    public Yodo1MasAppLovinMaxBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isMax() {
        return true;
    }

    public boolean isBannerAdvertLoaded() {
        return this.bannerAd != null && this.getBannerAdId() != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter == null || !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || !TextUtils.isEmpty((CharSequence)this.currBannerUnitId) && adId.adId.equals(this.currBannerUnitId))) {
            this.bannerAd = new MaxAdView(adId.adId, (Context)activity);
            this.bannerAd.setListener(this.bannerListener);
            if (this.revenueListener != null) {
                this.bannerAd.setRevenueListener(this.revenueListener);
            }
            this.currBannerUnitId = adId.adId;
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String amazonUnitId;
            String message = "method: loadBannerAdvert, load banner ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.setBannerSize(activity, this.bannerAd);
            if (TextUtils.isEmpty((CharSequence)this.bannerConfig.placement)) {
                this.bannerAd.setPlacement(this.bannerConfig.placement);
            }
            if (!TextUtils.isEmpty((CharSequence)(amazonUnitId = Yodo1MasAppLovinMaxUtil.getAmazonUnitId(adId))) && AdRegistration.isInitialized()) {
                this.loadAmazonAdfirst(amazonUnitId, this.bannerAd);
            } else {
                this.bannerAd.loadAd();
            }
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    private void loadAmazonAdfirst(String amazonUnitId, final MaxAdView bannerAd) {
        String amazonAdSlotId = amazonUnitId;
        MaxAdFormat adFormat = MaxAdFormat.BANNER;
        AppLovinSdkUtils.Size rawSize = adFormat.getSize();
        DTBAdSize size = new DTBAdSize(rawSize.getWidth(), rawSize.getHeight(), amazonAdSlotId);
        DTBAdRequest adLoader = new DTBAdRequest();
        adLoader.setSizes(new DTBAdSize[]{size});
        adLoader.loadAd(new DTBAdCallback(){

            public void onFailure(@NonNull AdError adError) {
                bannerAd.setLocalExtraParameter("amazon_ad_error", (Object)adError);
                bannerAd.loadAd();
            }

            public void onSuccess(@NonNull DTBAdResponse dtbAdResponse) {
                bannerAd.setLocalExtraParameter("amazon_ad_response", (Object)dtbAdResponse);
                bannerAd.loadAd();
            }
        });
    }

    private void setBannerSize(Activity activity, MaxAdView bannerAd) {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Yodo1MasLog.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            int width = -1;
            int heightDp = MaxAdFormat.BANNER.getAdaptiveSize(activity).getHeight();
            int heightPx = AppLovinSdkUtils.dpToPx((Context)activity, (int)heightDp);
            bannerAd.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, heightPx));
            bannerAd.setExtraParameter("adaptive_banner", "true");
        }
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.currBannerUnitId = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }

    public double getBestPrice() {
        return this.price * 1000.0;
    }
}

