/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxUtil;
import com.yodo1.mas.mediation.applovin.Yodo1MasMaxAdRecordListener;
import com.yodo1.mas.utils.Yodo1MasSystemUtil;

public class Yodo1MasAppLovinMaxInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private double price;
    private final MaxAdListener interstitialListener = new MaxAdListener(){

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxInterstitialAdapter.this.price = ad.getRevenue();
            Yodo1MasAdRequestResultInfo result = Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Interstitial, Yodo1MasAppLovinMaxInterstitialAdapter.this.advertCode, ad.getAdUnitId(), true, Yodo1MasAppLovinMaxInterstitialAdapter.this.getAdLoadDuration(), ad.getWaterfall(), null, null);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackLoad(result);
        }

        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, interstitial, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo result = Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Interstitial, Yodo1MasAppLovinMaxInterstitialAdapter.this.advertCode, adUnitId, false, Yodo1MasAppLovinMaxInterstitialAdapter.this.getAdLoadDuration(), adError.getWaterfall(), adError.getCode() + "", adError.getMessage());
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), result);
        }

        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackOpen();
            if (Yodo1MasAppLovinMaxInterstitialAdapter.this.adRecordListener != null) {
                Yodo1MasAppLovinMaxInterstitialAdapter.this.adRecordListener.onAdDisplayed(Yodo1Mas.AdType.Interstitial, ad);
            }
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackClose();
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackClick();
        }
    };
    private MaxInterstitialAd interstitialAd;
    private MaxAdRevenueListener revenueListener;
    private Yodo1MasMaxAdRecordListener adRecordListener;
    private boolean isFirstLoad = true;

    public Yodo1MasAppLovinMaxInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && this.interstitialAd.isReady();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        Yodo1MasAdapterBase.AdId adIdObj = this.getAdId();
        if (adIdObj == null || TextUtils.isEmpty((CharSequence)adIdObj.adId)) {
            return;
        }
        String adId = adIdObj.adId;
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.interstitialAd = new MaxInterstitialAd(adId, (Context)activity);
        this.interstitialAd.setListener(this.interstitialListener);
        if (this.revenueListener != null) {
            this.interstitialAd.setRevenueListener(this.revenueListener);
        }
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        String amazonUnitId = Yodo1MasAppLovinMaxUtil.getAmazonUnitId(adIdObj);
        if (this.isFirstLoad && !TextUtils.isEmpty((CharSequence)amazonUnitId) && AdRegistration.isInitialized()) {
            this.isFirstLoad = false;
            this.loadAmazonAdfirst(activity, amazonUnitId, this.interstitialAd);
        } else {
            this.interstitialAd.loadAd();
        }
    }

    private void loadAmazonAdfirst(Activity activity, String amazonUnitId, final MaxInterstitialAd interstitialAd) {
        DTBAdRequest adLoader = new DTBAdRequest();
        DTBAdSize.DTBVideo dtbAdSize = new DTBAdSize.DTBVideo(320, 480, amazonUnitId);
        int orientation = Yodo1MasSystemUtil.getCurOrientation((Context)activity);
        if (2 == orientation) {
            dtbAdSize = new DTBAdSize.DTBVideo(480, 320, amazonUnitId);
        }
        adLoader.setSizes(new DTBAdSize[]{dtbAdSize});
        adLoader.loadAd(new DTBAdCallback(){

            public void onSuccess(@NonNull DTBAdResponse dtbAdResponse) {
                interstitialAd.setLocalExtraParameter("amazon_ad_response", (Object)dtbAdResponse);
                interstitialAd.loadAd();
            }

            public void onFailure(@NonNull AdError adError) {
                interstitialAd.setLocalExtraParameter("amazon_ad_error", (Object)adError);
                interstitialAd.loadAd();
            }
        });
    }

    public void destroy() {
        super.destroy();
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
        }
        this.interstitialAd = null;
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.interstitialPlacement)) {
                this.interstitialAd.showAd(this.interstitialPlacement);
            } else {
                this.interstitialAd.showAd();
            }
        }
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }

    public double getPrice() {
        return this.price * 1000.0;
    }
}

