/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.os.Bundle;
import android.text.TextUtils;
import com.applovin.mediation.MaxAdWaterfallInfo;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxMediatedNetworkInfo;
import com.applovin.mediation.MaxNetworkResponseInfo;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.Yodo1MasDataAnalytics;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.helper.model.Yodo1MasNetworkMediationAdapter;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Yodo1MasAppLovinMaxUtil {
    private static final Map<String, String> mappingMap = Yodo1MasAppLovinMaxUtil.getNetworkNameMapping();

    private static Map<String, String> getNetworkNameMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AdMob", "admob");
        map.put("Google Ad Manager", "gam_google");
        map.put("AppLovin", "applovin");
        map.put("Facebook", "facebook");
        map.put("Fyber", "fyber");
        map.put("InMobi", "inmobi");
        map.put("ironSource", "ironsource");
        map.put("Mintegral", "mintegral");
        map.put("Pangle", "pangle");
        map.put("Tapjoy", "tapjoy");
        map.put("Unity Ads", "unity");
        map.put("Vungle", "vungle");
        map.put("Yandex", "yandex");
        map.put("Amazon Publisher Services", "amazon");
        map.put("BidMachine", "bidmachine");
        map.put("BigoAds", "bigo");
        map.put("CustomSDK", "amazon");
        return map;
    }

    public static String getAmazonUnitId(Yodo1MasAdapterBase.AdId adIdObj) {
        String amazonUnitId = null;
        if (adIdObj != null && adIdObj.object instanceof Yodo1MasNetworkMediationAdapter) {
            Yodo1MasNetworkMediationAdapter amazon = (Yodo1MasNetworkMediationAdapter)adIdObj.object;
            amazonUnitId = amazon.unit_id;
        }
        return amazonUnitId;
    }

    public static Yodo1MasAdRequestResultInfo getAdRequestResult(Yodo1Mas.AdType adType, String mediationName, String unitId, boolean isAdLoaded, long duration, MaxAdWaterfallInfo maxWaterfallInfo, String adErrorCode, String adErrorMessage) {
        List maxInfofoList;
        Yodo1MasAdRequestResultInfo result = new Yodo1MasAdRequestResultInfo();
        result.isMaxMediation = true;
        result.mediationName = mediationName;
        result.adType = adType;
        result.adResult = isAdLoaded ? Yodo1MasDataAnalytics.AdResult.SUCCESS.name : Yodo1MasDataAnalytics.AdResult.FAIL.name;
        result.adDuration = duration;
        result.adCurrentMediation = mediationName;
        result.mediationUnitId = unitId;
        result.adErrorCode = adErrorCode;
        result.adErrorMessage = adErrorMessage;
        List list = maxInfofoList = maxWaterfallInfo != null ? maxWaterfallInfo.getNetworkResponses() : null;
        if (maxInfofoList != null && maxInfofoList.size() > 0) {
            ArrayList<Yodo1MasAdRequestResultInfo.Yodo1MasWaterfallInfo> waterfallInfoList = new ArrayList<Yodo1MasAdRequestResultInfo.Yodo1MasWaterfallInfo>();
            for (MaxNetworkResponseInfo maxInfo : maxInfofoList) {
                MaxNetworkResponseInfo.AdLoadState adLoadState = maxInfo.getAdLoadState();
                if (adLoadState == MaxNetworkResponseInfo.AdLoadState.AD_LOAD_NOT_ATTEMPTED) continue;
                if (adLoadState == MaxNetworkResponseInfo.AdLoadState.AD_LOADED) {
                    result.adCurrentSource = Yodo1MasAppLovinMaxUtil.formatMaxNetworkName(Yodo1MasAppLovinMaxUtil.getMAXNetworkAdapterName(maxInfo));
                }
                Yodo1MasAdRequestResultInfo.Yodo1MasWaterfallInfo info = new Yodo1MasAdRequestResultInfo.Yodo1MasWaterfallInfo();
                info.adNetwork = Yodo1MasAppLovinMaxUtil.formatMaxNetworkName(Yodo1MasAppLovinMaxUtil.getMAXNetworkAdapterName(maxInfo));
                info.placement_id = Yodo1MasAppLovinMaxUtil.getMAXNetworkAdapterPlacementId(maxInfo);
                info.duration = maxInfo.getLatencyMillis();
                info.result = adLoadState == MaxNetworkResponseInfo.AdLoadState.AD_LOADED ? Yodo1MasDataAnalytics.AdResult.SUCCESS.name : Yodo1MasDataAnalytics.AdResult.FAIL.name;
                MaxError maxError = maxInfo.getError();
                if (maxError != null) {
                    info.errorCode = maxError.getCode() + "";
                    info.errorMessage = maxError.getMessage();
                }
                info.mediation = mediationName;
                waterfallInfoList.add(info);
            }
            result.waterfallInfoList = waterfallInfoList;
        }
        return result;
    }

    private static String formatMaxNetworkName(String maxNetworkAdapterName) {
        if (TextUtils.isEmpty((CharSequence)maxNetworkAdapterName)) {
            return maxNetworkAdapterName;
        }
        if ((maxNetworkAdapterName = maxNetworkAdapterName.trim()).endsWith("Native")) {
            maxNetworkAdapterName = maxNetworkAdapterName.replace("Native", "").trim();
        }
        if (mappingMap.containsKey(maxNetworkAdapterName)) {
            return mappingMap.get(maxNetworkAdapterName);
        }
        return maxNetworkAdapterName;
    }

    private static String getMAXNetworkAdapterName(MaxNetworkResponseInfo networkResponse) {
        Bundle credentials;
        String maxNetworkAdapterName;
        if (networkResponse == null) {
            return null;
        }
        MaxMediatedNetworkInfo networkInfo = networkResponse.getMediatedNetwork();
        String string = maxNetworkAdapterName = networkInfo != null ? networkInfo.getName() : null;
        if (TextUtils.isEmpty((CharSequence)maxNetworkAdapterName) && (credentials = networkResponse.getCredentials()) != null && credentials.containsKey("network_name")) {
            maxNetworkAdapterName = credentials.getString("network_name");
        }
        return maxNetworkAdapterName;
    }

    private static String getMAXNetworkAdapterPlacementId(MaxNetworkResponseInfo networkResponse) {
        if (networkResponse == null) {
            return null;
        }
        Bundle credentials = networkResponse.getCredentials();
        if (credentials != null && credentials.containsKey("placement_id")) {
            return credentials.getString("placement_id");
        }
        return null;
    }

    private static void printMAXAdLoadResultInfo(MaxNetworkResponseInfo networkResponse) {
        if (networkResponse == null) {
            return;
        }
        String waterfallInfoStr = "Network name -> " + networkResponse.getMediatedNetwork().getName() + "  " + networkResponse.getMediatedNetwork().getAdapterClassName();
        Yodo1MasLog.d((String)"Yodo1MasAppLovinMaxUtil", (String)("printMAXAdLoadResultInfo: " + waterfallInfoStr));
    }
}

