package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.res.Configuration;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasNetworkNameUtils;
import com.yodo1.mas.utils.Yodo1MasSystemUtil;

public class Yodo1MasAppLovinMaxInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final MaxAdListener interstitialListener = new MaxAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            price = ad.getRevenue() * 1000;

            adNetworkUnitId = ad.getAdUnitId();
            adSourceUnitId = ad.getNetworkPlacement();
            revenue = ad.getRevenue();
            revenuePrecision = ad.getRevenuePrecision();
            String originNetworkName = Yodo1MasAppLovinMaxUtil.getLoadedNetworkName(ad.getWaterfall());
            networkName = Yodo1MasNetworkNameUtils.getNetworkName(originNetworkName);

            Yodo1MasAdRequestResultInfo result =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Interstitial, advertCode,
                            ad.getAdUnitId(), true, getAdLoadDuration(), ad.getWaterfall(), null, null);
            callbackLoad(result);
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, interstitial, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo result =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Interstitial, advertCode,
                            adUnitId, false, getAdLoadDuration(), adError.getWaterfall(), adError.getCode() + "", adError.getMessage());
            callbackError(error, adError.getCode(), adError.getMessage(), result);
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackOpen();
            if (adRecordListener != null) {
                adRecordListener.onAdDisplayed(Yodo1Mas.AdType.Interstitial, ad);
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        @Override
        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            adSource = ad.getNetworkName();
            callbackClose();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }
    };

    private MaxInterstitialAd interstitialAd;
    private Yodo1MasMaxAdRecordListener adRecordListener;
    private boolean isFirstLoad = true;

    public Yodo1MasAppLovinMaxInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        Yodo1MasAdapterBase.AdId adIdObj = getAdId();
        if (adIdObj == null || TextUtils.isEmpty(adIdObj.adId)) return;

        String adId = adIdObj.adId;
        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        interstitialAd = new MaxInterstitialAd(adId, activity);
        interstitialAd.setListener(interstitialListener);

        adLoadStartTimeStamp = System.currentTimeMillis();
        String amazonUnitId = Yodo1MasAppLovinMaxUtil.getAmazonUnitId(adIdObj);
        if (isFirstLoad && !TextUtils.isEmpty(amazonUnitId) && AdRegistration.isInitialized()) {
            isFirstLoad = false;
            loadAmazonAdfirst(activity, amazonUnitId, interstitialAd);
        } else {
            interstitialAd.loadAd();
        }
    }

    private void loadAmazonAdfirst(Activity activity, String amazonUnitId, MaxInterstitialAd interstitialAd) {
        DTBAdRequest adLoader = new DTBAdRequest();
        DTBAdSize dtbAdSize = new DTBAdSize.DTBVideo(320, 480, amazonUnitId);

        int orientation = Yodo1MasSystemUtil.getCurOrientation(activity);
        if (Configuration.ORIENTATION_LANDSCAPE == orientation) {
            dtbAdSize = new DTBAdSize.DTBVideo(480, 320, amazonUnitId);
        }

        adLoader.setSizes(dtbAdSize);
        adLoader.loadAd(new DTBAdCallback() {
            @Override
            public void onSuccess(@NonNull final DTBAdResponse dtbAdResponse) {
                interstitialAd.setLocalExtraParameter("amazon_ad_response", dtbAdResponse);
                interstitialAd.loadAd();
            }

            @Override
            public void onFailure(@NonNull final AdError adError) {
                interstitialAd.setLocalExtraParameter("amazon_ad_error", adError);
                interstitialAd.loadAd();
            }
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        if (interstitialAd != null) {
            interstitialAd.destroy();
        }
        interstitialAd = null;
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            interstitialAd.showAd(placement, customData);
        }
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }

}
