package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAppOpenAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasNetworkNameUtils;

public class Yodo1MasApplovinMaxAppOpenAdapter extends Yodo1MasAppOpenAdapterBase {

    private MaxAppOpenAd appOpenAd;
    private Yodo1MasMaxAdRecordListener adRecordListener;

    private final MaxAdListener appOpenAdlListener = new MaxAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            price = ad.getRevenue() * 1000;

            adNetworkUnitId = ad.getAdUnitId();
            adSourceUnitId = ad.getNetworkPlacement();
            revenue = ad.getRevenue();
            revenuePrecision = ad.getRevenuePrecision();
            String originNetworkName = Yodo1MasAppLovinMaxUtil.getLoadedNetworkName(ad.getWaterfall());
            networkName = Yodo1MasNetworkNameUtils.getNetworkName(originNetworkName);

            Yodo1MasAdRequestResultInfo adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.AppOpen, advertCode,
                            ad.getAdUnitId(), true, getAdLoadDuration(), ad.getWaterfall(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackOpen();
            if (adRecordListener != null) {
                adRecordListener.onAdDisplayed(Yodo1Mas.AdType.AppOpen, ad);
            }
        }

        @Override
        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            adSource = ad.getNetworkName();
            callbackClose();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError error) {
            String message = "method: onAdLoadFailed, appOpenAd, AdUnitId: " + adUnitId + ", error: " + error.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError yodo1MasError = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.AppOpen, advertCode,
                            adUnitId, false, getAdLoadDuration(), error.getWaterfall(), error.getCode() + "", error.getMessage());
            callbackError(yodo1MasError, error.getCode(), error.getMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError error) {
            String message = "method: onAdDisplayFailed, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", error: " + error.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError yodo1MasError = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(yodo1MasError, error.getCode(), error.getMessage(), null);
        }
    };

    public Yodo1MasApplovinMaxAppOpenAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isAppOpenAdLoaded() {
        return appOpenAd != null && appOpenAd.isReady();
    }

    @Override
    public void loadAppOpenAdvert(Activity activity) {
        super.loadAppOpenAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;
        if (appOpenStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadAppOpenAdvert, loading AppOpen ad...";
        Yodo1MasLog.d(TAG, message);
        trackLoadTime();

        appOpenStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        appOpenAd = new MaxAppOpenAd(adId, activity);
        appOpenAd.setListener(appOpenAdlListener);
        appOpenAd.loadAd();
    }

    @Override
    public void showAppOpenAdvertFromActivity(Activity activity) {
        super.showAppOpenAdvertFromActivity(activity);
        if (isAppOpenAdLoaded()) {
            String message = "method: showAppOpenAdvert, show appOpen ad...";
            Yodo1MasLog.d(TAG, message);
            appOpenAd.showAd(placement, customData);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (appOpenAd != null) {
            appOpenAd.destroy();
        }
        appOpenAd = null;
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }

}
