/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinBannerAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinInterstitialAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasAppLovinAdapter
extends Yodo1MasAdapterBase {
    public static void setAppLoinPrivacy(Activity activity) {
        if (activity == null) {
            return;
        }
        AppLovinPrivacySettings.setHasUserConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent(), (Context)activity);
        AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted(), (Context)activity);
        AppLovinPrivacySettings.setDoNotSell((boolean)Yodo1MasHelper.getInstance().isCCPADoNotSell(), (Context)activity);
    }

    public String getAdvertCode() {
        return "applovin";
    }

    public String networkName() {
        return "AppLovin";
    }

    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    public String getMediationVersion() {
        return "4.14.2";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback initCallback) {
        Yodo1MasAppLovinAdapter yodo1MasAppLovinAdapter = this;
        super.initSDK(activity, config, initCallback);
        if (!yodo1MasAppLovinAdapter.isInitSDK()) {
            this.init = true;
            AppLovinSdk.initializeSdk((Context)this.currentActivity, object -> {
                Yodo1MasAppLovinAdapter yodo1MasAppLovinAdapter = this;
                object = "method: onSdkInitialized, configuration: " + object.getConsentDialogState();
                Yodo1MasLog.d((String)yodo1MasAppLovinAdapter.TAG, (String)object);
                yodo1MasAppLovinAdapter.updatePrivacy();
                if (initCallback != null) {
                    initCallback.onAdapterInitSuccessful(this.getAdvertCode());
                }
            });
        } else if (initCallback != null) {
            initCallback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        Yodo1MasAppLovinAdapter yodo1MasAppLovinAdapter = this;
        super.updatePrivacy();
        Yodo1MasAppLovinAdapter.setAppLoinPrivacy(yodo1MasAppLovinAdapter.currentActivity);
    }

    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAppLovinRewardAdapter.class;
    }

    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAppLovinInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAppLovinBannerAdapter.class;
    }

    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

