/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxAd;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxBannerAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxInterstitialAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxNativeAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxRewardAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasApplovinMaxAppOpenAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasMaxAdRecordListener;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reportad.Yodo1MasAdRecord;
import com.yodo1.mas.reportad.Yodo1MasAdReportHelper;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import com.yodo1.mas.utils.Yodo1MasUtils;

public class Yodo1MasAppLovinMaxAdapter
extends Yodo1MasAdapterBase
implements Yodo1MasMaxAdRecordListener {
    public String getAdvertCode() {
        return "APPLOVIN";
    }

    public String networkName() {
        return "AppLovin";
    }

    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    public String getMediationVersion() {
        return "4.14.3";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback initCallback) {
        Yodo1MasAppLovinMaxAdapter yodo1MasAppLovinMaxAdapter = this;
        super.initSDK(activity, config, initCallback);
        if (!yodo1MasAppLovinMaxAdapter.isInitSDK()) {
            this.init = true;
            if (this.isMax()) {
                AppLovinSdk.getInstance((Context)this.currentActivity).setMediationProvider("max");
            }
            Yodo1MasAppLovinMaxAdapter yodo1MasAppLovinMaxAdapter2 = this;
            yodo1MasAppLovinMaxAdapter2.updatePrivacy();
            AppLovinSdk.initializeSdk((Context)yodo1MasAppLovinMaxAdapter2.currentActivity, object2 -> {
                object2 = "method: onSdkInitialized, configuration: " + object2.getConsentDialogState();
                Yodo1MasLog.d((String)this.TAG, (String)object2);
                if (initCallback != null) {
                    initCallback.onAdapterInitSuccessful(this.getAdvertCode());
                }
                if (Yodo1MasUtils.getMetaData((Context)activity, (String)"com.yodo1.mas.EnableAppLovinMediationDebugger", (boolean)false)) {
                    AppLovinSdk.getInstance((Context)activity).showMediationDebugger();
                }
                if (!TextUtils.isEmpty((CharSequence)(initCallback = Yodo1MasHelper.getInstance().getUserIdentifier()))) {
                    this.updateUserIdentifier((String)initCallback);
                }
            });
        } else if (initCallback != null) {
            initCallback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        Yodo1MasAppLovinMaxAdapter yodo1MasAppLovinMaxAdapter = this;
        super.updatePrivacy();
        if (yodo1MasAppLovinMaxAdapter.currentActivity != null) {
            AppLovinPrivacySettings.setHasUserConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent(), (Context)this.currentActivity);
            AppLovinPrivacySettings.setDoNotSell((boolean)Yodo1MasHelper.getInstance().isCCPADoNotSell(), (Context)this.currentActivity);
        }
    }

    public void updateUserIdentifier(String string) {
        if (this.currentActivity != null && !TextUtils.isEmpty((CharSequence)string)) {
            AppLovinSdk.getInstance((Context)this.currentActivity).setUserIdentifier(string);
        }
    }

    public boolean isMax() {
        return true;
    }

    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAppLovinMaxRewardAdapter.class;
    }

    public Yodo1MasRewardAdapterBase getRewardAdapter(Yodo1MasAdapterBase.AdId adId) {
        Yodo1MasAppLovinMaxRewardAdapter yodo1MasAppLovinMaxRewardAdapter = (Yodo1MasAppLovinMaxRewardAdapter)super.getRewardAdapter(adId);
        yodo1MasAppLovinMaxRewardAdapter.setAdRecordListener(this);
        return yodo1MasAppLovinMaxRewardAdapter;
    }

    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAppLovinMaxInterstitialAdapter.class;
    }

    public Yodo1MasInterstitialAdapterBase getInterstitialAdapter(Yodo1MasAdapterBase.AdId adId) {
        Yodo1MasAppLovinMaxInterstitialAdapter yodo1MasAppLovinMaxInterstitialAdapter = (Yodo1MasAppLovinMaxInterstitialAdapter)super.getInterstitialAdapter(adId);
        yodo1MasAppLovinMaxInterstitialAdapter.setAdRecordListener(this);
        return yodo1MasAppLovinMaxInterstitialAdapter;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return Yodo1MasAppLovinMaxNativeAdapter.class;
    }

    public Yodo1MasNativeAdapterBase getNativeAdapter() {
        return (Yodo1MasAppLovinMaxNativeAdapter)super.getNativeAdapter();
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAppLovinMaxBannerAdapter.class;
    }

    public Yodo1MasBannerAdapterBase getBannerAdapter() {
        return (Yodo1MasAppLovinMaxBannerAdapter)super.getBannerAdapter();
    }

    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return Yodo1MasApplovinMaxAppOpenAdapter.class;
    }

    public Yodo1MasAppOpenAdapterBase getAppOpenAdapter(Yodo1MasAdapterBase.AdId adId) {
        Yodo1MasApplovinMaxAppOpenAdapter yodo1MasApplovinMaxAppOpenAdapter = (Yodo1MasApplovinMaxAppOpenAdapter)super.getAppOpenAdapter(adId);
        yodo1MasApplovinMaxAppOpenAdapter.setAdRecordListener(this);
        return yodo1MasApplovinMaxAppOpenAdapter;
    }

    @Override
    public void onAdDisplayed(Yodo1Mas.AdType adType, MaxAd maxAd) {
        Yodo1MasAdRecord yodo1MasAdRecord;
        Yodo1MasAppLovinMaxAdapter yodo1MasAppLovinMaxAdapter = this = yodo1MasAdRecord;
        this();
        ((Yodo1MasAdRecord)this).mas_ad_type = adType.getValue();
        ((Yodo1MasAdRecord)this).ad_format = maxAd.getFormat().getLabel();
        ((Yodo1MasAdRecord)this).ad_network = maxAd.getNetworkName();
        ((Yodo1MasAdRecord)yodo1MasAppLovinMaxAdapter).ad_unit_id = maxAd.getAdUnitId();
        ((Yodo1MasAdRecord)yodo1MasAppLovinMaxAdapter).video_url = null;
        ((Yodo1MasAdRecord)yodo1MasAppLovinMaxAdapter).serve_id = null;
        ((Yodo1MasAdRecord)this).creative_id = maxAd.getCreativeId();
        ((Yodo1MasAdRecord)this).ad_review_creative_id = maxAd.getAdReviewCreativeId();
        ((Yodo1MasAdRecord)this).dsp_name = maxAd.getDspName();
        yodo1MasAdRecord.dsp_id = maxAd.getDspId();
        yodo1MasAdRecord.ad_display_timestamp = System.currentTimeMillis();
        yodo1MasAdRecord.advertiser = null;
        yodo1MasAdRecord.ad_package_name = null;
        Yodo1MasAdReportHelper.getInstance().addRecord((Yodo1MasAdRecord)this);
    }
}

