package com.yodo1.mas.mediation.applovin;

import android.app.Activity;

import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasAppLovinInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {
    private final AppLovinAdVideoPlaybackListener interstitialPlayListener = new AppLovinAdVideoPlaybackListener() {
        @Override
        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            String message = "method: videoPlaybackBegan, interstitial: ";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
            String message = "method: videoPlaybackEnded, interstitial: ";
            Yodo1MasLog.d(TAG, message);
        }
    };
    private final AppLovinAdDisplayListener interstitialDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, interstitial: ";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, interstitial: ";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }
    };
    private final AppLovinAdClickListener interstitialClickListener = new AppLovinAdClickListener() {
        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            String message = "method: adClicked, interstitial: ";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }
    };
    private AppLovinAd interstitialAd;
    private final AppLovinAdLoadListener interstitialLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, interstitial: ";
            Yodo1MasLog.d(TAG, message);
            interstitialAd = appLovinAd;
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void failedToReceiveAd(int code) {
            String message = "method: failedToReceiveAd, error: " + code;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), code+"", message);
            callbackError(error, code, message, adRequestResult);
        }
    };

    public Yodo1MasAppLovinInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && super.isInterstitialAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        AppLovinSdk.getInstance(activity).getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, interstitialLoadListener);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);

            final AppLovinSdk sdk = AppLovinSdk.getInstance(activity);
            final AppLovinInterstitialAdDialog dialog = AppLovinInterstitialAd.create(sdk, activity);
            dialog.setAdDisplayListener(interstitialDisplayListener);
            dialog.setAdClickListener(interstitialClickListener);
            dialog.setAdVideoPlaybackListener(interstitialPlayListener);
            dialog.showAndRender(interstitialAd);
        }
    }
}
