package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.applovin.mediation.MaxAd;
import com.applovin.sdk.AppLovinMediationProvider;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkInitializationConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reportad.Yodo1MasAdRecord;
import com.yodo1.mas.reportad.Yodo1MasAdReportHelper;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import com.yodo1.mas.utils.Yodo1MasUtils;

public class Yodo1MasAppLovinMaxAdapter extends Yodo1MasAdapterBase implements Yodo1MasMaxAdRecordListener {

    @Override
    public String getAdvertCode() {
        return "APPLOVIN";
    }

    @Override
    public String networkName() {
        return "AppLovin";
    }

    @Override
    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public boolean isMax() {
        return true;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            updatePrivacy();

            String applovinSdkKey = Yodo1MasUtils.getMetaData(activity.getApplicationContext(), "applovin.sdk.key", "");
            AppLovinSdkInitializationConfiguration.Builder builder = AppLovinSdkInitializationConfiguration.builder(applovinSdkKey, activity);
            if (isMax()) {
                builder.setMediationProvider(AppLovinMediationProvider.MAX);
            }
            AppLovinSdkInitializationConfiguration initConfig = builder.build();

            AppLovinSdk.getInstance(activity).initialize(initConfig, new AppLovinSdk.SdkInitializationListener() {
                @Override
                public void onSdkInitialized(AppLovinSdkConfiguration appLovinSdkConfiguration) {
                    String message = "method: onSdkInitialized, configuration: " + appLovinSdkConfiguration.getConsentDialogState();
                    Yodo1MasLog.d(TAG, message);

                    if (callback != null) {
                        callback.onAdapterInitSuccessful(getAdvertCode());
                    }
                    if (Yodo1MasUtils.getMetaData(activity, "com.yodo1.mas.EnableAppLovinMediationDebugger", false)) {
                        AppLovinSdk.getInstance(activity).showMediationDebugger();
                    }

                    String userIdentifier = Yodo1MasHelper.getInstance().getUserIdentifier();
                    if (!TextUtils.isEmpty(userIdentifier)) {
                        updateUserIdentifier(userIdentifier);
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        if (currentActivity != null) {
            AppLovinPrivacySettings.setHasUserConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent(), currentActivity);
            AppLovinPrivacySettings.setDoNotSell(Yodo1MasHelper.getInstance().isCCPADoNotSell(), currentActivity);
        }
    }

    @Override
    public void updateUserIdentifier(String userIdentifier) {
        if (currentActivity != null && !TextUtils.isEmpty(userIdentifier)) {
            AppLovinSdkSettings settings = AppLovinSdk.getInstance(currentActivity).getSettings();
            settings.setUserIdentifier(userIdentifier);
        }
    }

    // Reward
    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAppLovinMaxRewardAdapter.class;
    }

    @Override
    public Yodo1MasRewardAdapterBase getRewardAdapter(AdId rewardAdId) {
        Yodo1MasAppLovinMaxRewardAdapter adapter = (Yodo1MasAppLovinMaxRewardAdapter) super.getRewardAdapter(rewardAdId);
        adapter.setAdRecordListener(Yodo1MasAppLovinMaxAdapter.this);
        return adapter;
    }

    // Interstitial
    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAppLovinMaxInterstitialAdapter.class;
    }

    @Override
    public Yodo1MasInterstitialAdapterBase getInterstitialAdapter(AdId interstitialAdId) {
        Yodo1MasAppLovinMaxInterstitialAdapter adapter = (Yodo1MasAppLovinMaxInterstitialAdapter) super.getInterstitialAdapter(interstitialAdId);
        adapter.setAdRecordListener(Yodo1MasAppLovinMaxAdapter.this);
        return adapter;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return Yodo1MasAppLovinMaxNativeAdapter.class;
    }

    @Override
    public Yodo1MasNativeAdapterBase getNativeAdapter() {
        return (Yodo1MasAppLovinMaxNativeAdapter) super.getNativeAdapter();
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAppLovinMaxBannerAdapter.class;
    }

    @Override
    public Yodo1MasBannerAdapterBase getBannerAdapter() {
        return (Yodo1MasAppLovinMaxBannerAdapter) super.getBannerAdapter();
    }

    // Rewarded Interstitial
    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return Yodo1MasApplovinMaxAppOpenAdapter.class;
    }

    @Override
    public Yodo1MasAppOpenAdapterBase getAppOpenAdapter(AdId appOpenAdId) {
        Yodo1MasApplovinMaxAppOpenAdapter adapter = (Yodo1MasApplovinMaxAppOpenAdapter) super.getAppOpenAdapter(appOpenAdId);
        adapter.setAdRecordListener(Yodo1MasAppLovinMaxAdapter.this);
        return adapter;
    }


    @Override
    public void onAdDisplayed(Yodo1Mas.AdType adType, MaxAd ad) {
        Yodo1MasAdRecord adRecord = new Yodo1MasAdRecord();
        adRecord.mas_ad_type = adType.getValue();
        adRecord.ad_format = ad.getFormat().getLabel();
        adRecord.ad_network = ad.getNetworkName();
        adRecord.ad_unit_id = ad.getAdUnitId();
        adRecord.video_url = null;
        adRecord.serve_id = null;
        adRecord.creative_id = ad.getCreativeId();
        adRecord.ad_review_creative_id = ad.getAdReviewCreativeId();
        adRecord.dsp_name = ad.getDspName();
        adRecord.dsp_id = ad.getDspId();
        adRecord.ad_display_timestamp = System.currentTimeMillis();
        adRecord.advertiser = null;
        adRecord.ad_package_name = null;
        Yodo1MasAdReportHelper.getInstance().addRecord(adRecord);
    }
}

interface Yodo1MasMaxAdRecordListener {
    void onAdDisplayed(Yodo1Mas.AdType adType, MaxAd ad);
}
