package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

public class Yodo1MasAppLovinMaxInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final MaxAdListener interstitialListener = new MaxAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = Yodo1MasAppLovinMaxUtil.getLoadedNetworkName(ad);
            price = ad.getRevenue() * 1000;

            adNetworkUnitId = ad.getAdUnitId();
            adSourceUnitId = ad.getNetworkPlacement();
            revenue = ad.getRevenue();
            revenuePrecision = ad.getRevenuePrecision();

            adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Interstitial, advertCode,
                            ad.getAdUnitId(), true, getAdLoadDuration(), ad.getWaterfall(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, interstitial, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Interstitial, advertCode,
                            adUnitId, false, getAdLoadDuration(), adError.getWaterfall(), adError.getCode() + "", adError.getMessage());
            callbackError(error, adError.getCode(), adError.getMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackOpen();
            if (adRecordListener != null) {
                adRecordListener.onAdDisplayed(Yodo1Mas.AdType.Interstitial, ad);
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        @Override
        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            adSource = ad.getNetworkName();
            callbackClose();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }
    };

    private MaxInterstitialAd interstitialAd;
    private Yodo1MasMaxAdRecordListener adRecordListener;

    public Yodo1MasAppLovinMaxInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        Yodo1MasAdapterBase.AdId adIdObj = getAdId();
        if (adIdObj == null || TextUtils.isEmpty(adIdObj.adId)) return;

        String adId = adIdObj.adId;
        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        interstitialAd = new MaxInterstitialAd(adId, activity);
        interstitialAd.setListener(interstitialListener);

        adLoadStartTimeStamp = System.currentTimeMillis();
        interstitialAd.loadAd();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (interstitialAd != null) {
            interstitialAd.destroy();
        }
        interstitialAd = null;
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            interstitialAd.showAd(placement, customData);
        }
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }

}
