package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

public class Yodo1MasAppLovinMaxRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final MaxRewardedAdListener rewardListener = new MaxRewardedAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = Yodo1MasAppLovinMaxUtil.getLoadedNetworkName(ad);;
            price = ad.getRevenue() * 1000;

            adNetworkUnitId = ad.getAdUnitId();
            adSourceUnitId = ad.getNetworkPlacement();
            revenue = ad.getRevenue();
            revenuePrecision = ad.getRevenuePrecision();

            adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Reward, advertCode,
                            ad.getAdUnitId(), true, getAdLoadDuration(), ad.getWaterfall(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, reward, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult =
                    Yodo1MasAppLovinMaxUtil.getAdRequestResult(Yodo1Mas.AdType.Reward, advertCode,
                            adUnitId, false, getAdLoadDuration(), adError.getWaterfall(), adError.getCode() + "", adError.getMessage());
            callbackError(error, adError.getCode(), adError.getMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackOpen();
            if (adRecordListener != null) {
                adRecordListener.onAdDisplayed(Yodo1Mas.AdType.Reward, ad);
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, reward, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage(), null);
        }

        @Override
        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            price = 0;
            adSource = ad.getNetworkName();
            callbackClose();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }

        @Override
        public void onUserRewarded(MaxAd ad, MaxReward reward) {
            String message = "method: onUserRewarded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackEarned();
        }
    };
    private MaxRewardedAd rewardAd;
    private Yodo1MasMaxAdRecordListener adRecordListener;

    public Yodo1MasAppLovinMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        Yodo1MasAdapterBase.AdId adIdObj = getAdId();
        if (adIdObj == null || TextUtils.isEmpty(adIdObj.adId)) return;

        String adId = adIdObj.adId;
        if (TextUtils.isEmpty(adId)) return;
        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        rewardAd = MaxRewardedAd.getInstance(adId, activity);
        rewardAd.setListener(rewardListener);

        adLoadStartTimeStamp = System.currentTimeMillis();
        rewardAd.loadAd();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            rewardAd.showAd(placement, customData);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd.destroy();
        }
        rewardAd = null;
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }

}
