/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.Map;
import org.json.JSONObject;

public class Yodo1MasAppLovinAdapter
extends Yodo1MasAdapterBase {
    private AppLovinIncentivizedInterstitial rewardAd;
    private AppLovinAd interstitialAd;
    private AppLovinAdView bannerAd;
    private final AppLovinAdLoadListener rewardLoadListener = new AppLovinAdLoadListener(){

        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void failedToReceiveAd(int i) {
            String message = "method: failedToReceiveAd, error: " + i;
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasAppLovinAdapter.this.loadRewardAdvert();
            Yodo1MasAppLovinAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);
        }
    };
    private final AppLovinAdVideoPlaybackListener rewardPlayListener = new AppLovinAdVideoPlaybackListener(){

        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            String message = "method: videoPlaybackBegan, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
            String message = "method: videoPlaybackEnded, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
        }
    };
    private final AppLovinAdDisplayListener rewardDisplayListener = new AppLovinAdDisplayListener(){

        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
        }

        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinAdapter.this.loadRewardAdvert();
        }
    };
    private final AppLovinAdClickListener rewardClickListener = appLovinAd -> {
        String message = "method: adClicked, reward: " + appLovinAd.getAdIdNumber();
        Log.d((String)this.TAG, (String)message);
    };
    private final AppLovinAdRewardListener rewardedListener = new AppLovinAdRewardListener(){

        public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userRewardVerified, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userOverQuota, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userRewardRejected, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void validationRequestFailed(AppLovinAd appLovinAd, int i) {
            String message = "method: validationRequestFailed, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
            String message = "method: userDeclinedToViewAd, reward: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }
    };
    private final AppLovinAdLoadListener interstitialLoadListener = new AppLovinAdLoadListener(){

        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, interstitial: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.interstitialAd = appLovinAd;
            Yodo1MasAppLovinAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void failedToReceiveAd(int i) {
            String message = "method: failedToReceiveAd, error: " + i;
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasAppLovinAdapter.this.loadInterstitialAdvert();
            Yodo1MasAppLovinAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);
        }
    };
    private final AppLovinAdVideoPlaybackListener interstitialPlayListener = new AppLovinAdVideoPlaybackListener(){

        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            String message = "method: videoPlaybackBegan, interstitial: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
            String message = "method: videoPlaybackEnded, interstitial: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }
    };
    private final AppLovinAdDisplayListener interstitialDisplayListener = new AppLovinAdDisplayListener(){

        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, interstitial: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
        }

        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, interstitial: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinAdapter.this.loadInterstitialAdvert();
        }
    };
    private final AppLovinAdClickListener interstitialClickListener = new AppLovinAdClickListener(){

        public void adClicked(AppLovinAd appLovinAd) {
            String message = "method: adClicked, interstitial: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }
    };
    private final AppLovinAdLoadListener bannerLoadListener = new AppLovinAdLoadListener(){

        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAppLovinAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            Yodo1MasAppLovinAdapter.this.callback(1003, Yodo1Mas.AdType.Banner, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
        }

        public void failedToReceiveAd(int i) {
            String message = "method: failedToReceiveAd, error: " + i;
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
            Yodo1MasAppLovinAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAppLovinAdapter.this.loadBannerAdvert();
            Yodo1MasAppLovinAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
        }
    };
    private final AppLovinAdViewEventListener bannerPlayListener = new AppLovinAdViewEventListener(){

        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adOpenedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adClosedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adLeftApplication, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
        }

        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            String message = "method: adFailedToDisplay, banner: " + appLovinAd.getAdIdNumber() + ", error:" + appLovinAdViewDisplayErrorCode;
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
        }
    };
    private final AppLovinAdDisplayListener bannerDisplayListener = new AppLovinAdDisplayListener(){

        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.callback(1001, Yodo1Mas.AdType.Banner, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
        }

        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinAdapter.this.callback(1002, Yodo1Mas.AdType.Banner, Yodo1MasAppLovinAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAppLovinAdapter.this.loadBannerAdvert();
        }
    };
    private final AppLovinAdClickListener bannerClickListener = appLovinAd -> {
        String message = "method: adClicked, banner: " + appLovinAd.getAdIdNumber();
        Log.d((String)this.TAG, (String)message);
    };

    public String getAdvertCode() {
        return "applovin";
    }

    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    public String getMediationVersion() {
        return "4.2.2";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            AppLovinSdk.initializeSdk((Context)this.currentActivity, configuration -> {
                String message = "method: onSdkInitialized, configuration: " + configuration.getConsentDialogState();
                Log.d((String)this.TAG, (String)message);
                this.updatePrivacy();
                this.loadRewardAdvert();
                this.loadInterstitialAdvert();
                this.loadBannerAdvert();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
            });
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        if (this.currentActivity != null) {
            AppLovinPrivacySettings.setHasUserConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent(), (Context)this.currentActivity);
            AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted(), (Context)this.currentActivity);
            AppLovinPrivacySettings.setDoNotSell((boolean)Yodo1MasHelper.getInstance().isCCPADoNotSell(), (Context)this.currentActivity);
        }
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return this.rewardAd != null && this.rewardAd.isAdReadyToDisplay();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        if (this.rewardAd == null) {
            this.rewardAd = AppLovinIncentivizedInterstitial.create((Context)this.currentActivity);
        }
        if (this.rewardAd != null) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.preload(this.rewardLoadListener);
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.show((Context)activity, this.rewardedListener, this.rewardPlayListener, this.rewardDisplayListener, this.rewardClickListener);
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (this.rewardAd != null) {
            this.rewardAd.dismiss();
        }
        this.rewardAd = null;
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return this.interstitialAd != null;
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        AppLovinSdk.getInstance((Context)activity.getApplicationContext()).getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, this.interstitialLoadListener);
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            if (this.interstitialAd != null) {
                AppLovinSdk sdk = AppLovinSdk.getInstance((Context)activity);
                AppLovinInterstitialAdDialog interstitialAdDialog = AppLovinInterstitialAd.create((AppLovinSdk)sdk, (Context)activity);
                interstitialAdDialog.setAdDisplayListener(this.interstitialDisplayListener);
                interstitialAdDialog.setAdClickListener(this.interstitialClickListener);
                interstitialAdDialog.setAdVideoPlaybackListener(this.interstitialPlayListener);
                interstitialAdDialog.showAndRender(this.interstitialAd);
            }
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        if (this.bannerAd == null) {
            this.bannerAd = new AppLovinAdView(AppLovinAdSize.BANNER, (Context)activity);
            this.bannerAd.setAdLoadListener(this.bannerLoadListener);
            this.bannerAd.setAdDisplayListener(this.bannerDisplayListener);
            this.bannerAd.setAdViewEventListener(this.bannerPlayListener);
            this.bannerAd.setAdClickListener(this.bannerClickListener);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, load banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd.loadNextAd();
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            Yodo1MasBanner.showBanner((Activity)activity, (View)this.bannerAd, (JSONObject)object);
        }
    }
}

