package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.util.Log;
import android.view.View;

import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

import androidx.annotation.NonNull;

public class Yodo1MasAppLovinBannerAdapter extends Yodo1MasBannerAdapterBase {

    private AppLovinAdView bannerAd;

    @Override
    public boolean isBannerAdvertLoaded() {
        return bannerAd != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter != null && !relateAdapter.isInitSDK()) {
            return;
        }

        if (bannerAd == null) {
            AppLovinAdSize bannerSize = getBannerSize();
            bannerAd = new AppLovinAdView(bannerSize, activity);
            bannerAd.setAdLoadListener(bannerLoadListener);
            bannerAd.setAdDisplayListener(bannerDisplayListener);
            bannerAd.setAdViewEventListener(bannerPlayListener);
            bannerAd.setAdClickListener(bannerClickListener);
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, load banner ad...";
            Log.d(TAG, message);
            bannerAd.loadNextAd();
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    private AppLovinAdSize getBannerSize() {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Log.d(TAG, "setBannerSize: size: " + size.name());

        if(Yodo1MasBannerAdSize.Banner == size) {
            return AppLovinAdSize.BANNER;
        }
        else if(Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            return AppLovinAdSize.MREC;
        }
        return AppLovinAdSize.BANNER;
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return true;
    }

    // Banner
    private final AppLovinAdLoadListener bannerLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, banner: " + appLovinAd.getAdIdNumber();
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            callback(Yodo1MasAdEvent.CODE_LOADED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void failedToReceiveAd(int i) {
            String message = "method: failedToReceiveAd, error: " + i;
            Log.d(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Banner);

            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            loadBannerAdvert();
            //loadBannerAdvertDelayed();
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
        }
    };

    private final AppLovinAdViewEventListener bannerPlayListener = new AppLovinAdViewEventListener() {
        @Override
        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adOpenedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Log.d(TAG, message);
        }

        @Override
        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adClosedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Log.d(TAG, message);
        }

        @Override
        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adLeftApplication, banner: " + appLovinAd.getAdIdNumber();
            Log.d(TAG, message);
        }

        @Override
        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            String message = "method: adFailedToDisplay, banner: " + appLovinAd.getAdIdNumber() + ", error:" + appLovinAdViewDisplayErrorCode;
            Log.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Banner);
        }
    };

    private final AppLovinAdDisplayListener bannerDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, banner: " + appLovinAd.getAdIdNumber();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, banner: " + appLovinAd.getAdIdNumber();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");

            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            loadBannerAdvert();
        }
    };

    private final AppLovinAdClickListener bannerClickListener = appLovinAd -> {
        String message = "method: adClicked, banner: " + appLovinAd.getAdIdNumber();
        Log.d(TAG, message);
    };
}
