package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.sdk.AppLovinSdkUtils;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

import androidx.annotation.NonNull;

public class Yodo1MasAppLovinMaxBannerAdapter extends Yodo1MasBannerAdapterBase {

    private MaxAdView bannerAd;
    private String currBannerUnitId;

    @Override
    public boolean isMax() {
        return true;
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        return bannerAd != null && getBannerAdId() != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && !TextUtils.isEmpty(adId.adId) && (TextUtils.isEmpty(currBannerUnitId) || !adId.adId.equals(currBannerUnitId))) {
            bannerAd = new MaxAdView(adId.adId, activity);
            bannerAd.setListener(bannerListener);
            currBannerUnitId = adId.adId;
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, load banner ad...";
            Log.d(TAG, message);

            setBannerSize(activity, bannerAd);
            if(TextUtils.isEmpty((bannerConfig.placement))) {
                bannerAd.setPlacement((bannerConfig.placement));
            }

            bannerAd.loadAd();
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }
    }

    private void setBannerSize(Activity activity, MaxAdView bannerAd) {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Log.d(TAG, "setBannerSize: size: " + size.name());
        if(Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            // Stretch to the width of the screen for banners to be fully functional
            int width = ViewGroup.LayoutParams.MATCH_PARENT;
            // Get the adaptive banner height.
            int heightDp = MaxAdFormat.BANNER.getAdaptiveSize(activity).getHeight();
            int heightPx = AppLovinSdkUtils.dpToPx(activity, heightDp);
            bannerAd.setLayoutParams(new FrameLayout.LayoutParams(width, heightPx));
            bannerAd.setExtraParameter("adaptive_banner", "true");
        }
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                currBannerUnitId = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }

    private final MaxAdViewAdListener bannerListener = new MaxAdViewAdListener() {
        @Override
        public void onAdExpanded(MaxAd ad) {
            String message = "method: onAdExpanded, banner: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void onAdCollapsed(MaxAd ad) {
            String message = "method: onAdCollapsed, banner: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");

            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            loadBannerAdvert();
        }

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, banner: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            callback(Yodo1MasAdEvent.CODE_LOADED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError maxError) {
            String message = "method: onAdLoadFailed, placementId: " + adUnitId + ", error:" + maxError.getAdLoadFailureInfo();
            Log.d(TAG, message);
            trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Banner);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            advertAdapterState = AdvertAdapterState.FAILED;
            callbackAdapterState();
            nextBanner();
            loadBannerAdvertDelayed();
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
//            String message = "method: onAdDisplayed, banner: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
//            Log.d(TAG, message);
//            callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError maxError) {
            String message = "method: onAdDisplayFailed, reward:" + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId() + ", error: " + maxError.getAdLoadFailureInfo();
            Log.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Banner);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            advertAdapterState = AdvertAdapterState.FAILED;
            callbackAdapterState();
            nextBanner();
            loadBannerAdvert();
        }

        @Override
        public void onAdHidden(MaxAd ad) {
//            String message = "method: onAdHidden, banner: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
//            Log.d(TAG, message);
//            bannerState = AdvertState.NONE;
//            loadBannerAdvert();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, banner: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d(TAG, message);
        }
    };

}
