/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxBannerAdapter;
import com.yodo1.mas.utils.Yodo1MasUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1MasAppLovinMaxAdapter
extends Yodo1MasAdapterBase {
    private MaxRewardedAd rewardAd;
    private MaxInterstitialAd interstitialAd;
    private final MaxRewardedAdListener rewardListener = new MaxRewardedAdListener(){

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, reward: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void onAdLoadFailed(String adUnitId, MaxError maxError) {
            String message = "method: onAdLoadFailed, placementId: " + adUnitId + ", error: " + maxError.getAdLoadFailureInfo();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasAppLovinMaxAdapter.this.nextReward();
            Yodo1MasAppLovinMaxAdapter.this.loadRewardAdvertDelayed();
        }

        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, reward: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError maxError) {
            String message = "method: onAdDisplayFailed, reward:" + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId() + ", error: " + maxError.getAdLoadFailureInfo();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasAppLovinMaxAdapter.this.nextReward();
            Yodo1MasAppLovinMaxAdapter.this.loadRewardAdvert();
        }

        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, reward: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxAdapter.this.loadRewardAdvert();
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, reward: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
        }

        public void onRewardedVideoStarted(MaxAd ad) {
            String message = "method: onRewardedVideoStarted, reward: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
        }

        public void onRewardedVideoCompleted(MaxAd ad) {
            String message = "method: onRewardedVideoCompleted, reward: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
        }

        public void onUserRewarded(MaxAd ad, MaxReward reward) {
            String message = "method: onUserRewarded, reward: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
        }
    };
    private final MaxAdListener interstitialListener = new MaxAdListener(){

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, interstitial: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void onAdLoadFailed(String adUnitId, MaxError maxError) {
            String message = "method: onAdLoadFailed, placementId: " + adUnitId + ", error:" + maxError.getAdLoadFailureInfo();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasAppLovinMaxAdapter.this.nextInterstitial();
            Yodo1MasAppLovinMaxAdapter.this.loadInterstitialAdvertDelayed();
        }

        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, interstitial: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError maxError) {
            String message = "method: onAdDisplayFailed, reward:" + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId() + ", error: " + maxError.getAdLoadFailureInfo();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasAppLovinMaxAdapter.this.nextInterstitial();
            Yodo1MasAppLovinMaxAdapter.this.loadInterstitialAdvert();
        }

        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, interstitial: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasAppLovinMaxAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxAdapter.this.loadInterstitialAdvert();
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, interstitial: " + ad.getNetworkName() + ", placementId: " + ad.getAdUnitId();
            Log.d((String)Yodo1MasAppLovinMaxAdapter.this.TAG, (String)message);
        }
    };

    public String getAdvertCode() {
        return "APPLOVIN";
    }

    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    public String getMediationVersion() {
        return "4.5.0";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (this.isMax()) {
                AppLovinSdk.getInstance((Context)this.currentActivity).setMediationProvider("max");
            }
            AppLovinSdk.initializeSdk((Context)this.currentActivity, configuration -> {
                String message = "method: onSdkInitialized, configuration: " + configuration.getConsentDialogState();
                Log.d((String)this.TAG, (String)message);
                this.updatePrivacy();
                this.loadRewardAdvert();
                this.loadInterstitialAdvert();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
                if (Yodo1MasUtils.getMetaData((Context)activity, (String)"com.yodo1.mas.EnableAppLovinMediationDebugger", (boolean)false)) {
                    AppLovinSdk.getInstance((Context)activity).showMediationDebugger();
                }
            });
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        if (this.currentActivity != null) {
            AppLovinPrivacySettings.setHasUserConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent(), (Context)this.currentActivity);
            AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted(), (Context)this.currentActivity);
            AppLovinPrivacySettings.setDoNotSell((boolean)Yodo1MasHelper.getInstance().isCCPADoNotSell(), (Context)this.currentActivity);
        }
    }

    public boolean isMax() {
        return true;
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return this.rewardAd != null && this.rewardAd.isReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            this.rewardAd = MaxRewardedAd.getInstance((String)adId.adId, (Activity)activity);
            this.rewardAd.setListener(this.rewardListener);
        }
        if (this.rewardAd != null) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.loadAd();
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            String placement = null;
            if (object != null && object.has("arg_placement")) {
                try {
                    placement = object.getString("arg_placement");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (this.isMax() && !TextUtils.isEmpty(placement)) {
                this.rewardAd.showAd(placement);
            } else {
                this.rewardAd.showAd();
            }
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return this.interstitialAd != null && this.interstitialAd.isReady();
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            this.interstitialAd = new MaxInterstitialAd(adId.adId, activity);
            this.interstitialAd.setListener(this.interstitialListener);
        }
        if (this.interstitialAd != null) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.loadAd();
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            String placement = null;
            if (object != null && object.has("arg_placement")) {
                try {
                    placement = object.getString("arg_placement");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (this.isMax() && !TextUtils.isEmpty(placement)) {
                this.interstitialAd.showAd(placement);
            } else {
                this.interstitialAd.showAd();
            }
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
        }
        this.interstitialAd = null;
    }

    public Yodo1MasBannerAdapterBase getYodo1MasBannerAdapter() {
        Yodo1MasAppLovinMaxBannerAdapter bannerAdapter = new Yodo1MasAppLovinMaxBannerAdapter();
        bannerAdapter.bannerAdIds.clear();
        bannerAdapter.bannerAdIds.addAll(this.bannerAdIds);
        bannerAdapter.relateAdapter = this;
        bannerAdapter.advertCode = this.getAdvertCode();
        bannerAdapter.sDKVersion = this.getSDKVersion();
        bannerAdapter.mediationVersion = this.getMediationVersion();
        return bannerAdapter;
    }
}

